function [ratio kms energy]=Marko_Siggia(f,P)
% Calculate the extension, force constant, and energy density of a 
% worm-like chain using the Marko-Siggia formula
% Input: 
%          f: force (pN)
%          P: persistence length (nm)
% Output: 
%          ratio: the ratio of extension to contour length (x/L)
%          kms: force constant (pN/nN) per unit contour length. The actual
%               force constant for the chain is kms/L where L is the 
%               contour length.
%          energy: elastic energy per unit contour length (pN.nm)

   n=length(f);
   if(n>1)
       ratio=zeros(size(f));
       for i=1:n
           ratio(i)=ext_force_formula1(f(i),P);
       end
   else
       ratio=ext_force_formula1(f,P);
   end
   if(nargout>=2)
      kms=4.1./P*(1+0.5.*(1-ratio).^-3);
   end
   if(nargout>=3)
       energy=4.1./P./4./(1-ratio).*ratio.*ratio.*(3-2.*ratio);
   end
end
               

       
