p=0.6; % peptide persistence length
M=1000;  % Maximum iterations
Emax=50; % Energy barrier of membrane fusion per SNARE complex
xc=1;

L1=2.5;
L2=6;
ratio=0.5;

% Read the energy landscape from the spreadsheet
data=xlsread('energy_landscape.xlsx');

aa=data(:,1);
c=data(:,2).*0.365; % Contour length
hc=data(:,3);  % hardcore size
e=data(:,4);  % Measured energy landscape
ea=data(:,5); % Hypothetical energy landscape

% Including the whole linker domain
%AA=-24:1:38;  % amino acid number relative to the ionic layer in the SNARE motif
% excluding the whole linker domain
AA=-24:0.5:29.5;  % amino acid number relative to the ionic layer in the SNARE motif
c=c-19*0.365; % Remove the linker domain 
N=length(AA); % Total number amino acids involved in zippering
C=interp1(aa,c,AA); % Contour length along AA
HC=interp1(aa,hc,AA); % Hard core size vs AA

dp0=[aa e];
% More data points used for spline to generate smooth energy landscape
dpa=[-20 2; -12 9; -9 9;-1 -25; 1 -30; 18 -36; 28 -54; 30 -58; 31 -53; 33 -53; 37 -63];
dpb=[dp0; dpa];
dp=sort(dpb,1);
E=spline(dpb(:,1),dpb(:,2),AA); % Energy vs AA through spline

dp0=[aa ea];
% More data points used for spline to generate smooth energy landscape
dp1=[-20 2; -12 9; -9 9;-1 -25; 22, -55; 26, -56.5; 30, -57.2];
dp2=[dp0; dp1];
dp=sort(dp2,1);
EA=spline(dp2(:,1),dp2(:,2),AA); % Energy vs AA through spline

figure
plot(AA,E,'-k',aa,e,'*r',dpb(:,1),dpb(:,2),'og',AA,EA,'-b',dp2(:,1),dp2(:,2),'og')
xlabel('AA')
ylabel('Energy (kT)')

% Calculate extension at different force 
f=zeros(size(AA));  % The equilibrium force between membranes and SNAREs
ext=zeros(size(AA));  % Total extension of the SNARE complex or the distance between two membranes
ext_C=zeros(size(AA)); % Extension of the unfolded polypeptides
V=zeros(size(AA));  % Membrane interactoin energy
E_SNARE=zeros(size(AA)); % Energy of loaded SNARE complex
Etotal=zeros(size(AA)); % Total energy of the loaded SNARE complex and the membranes
f0=10;
for i=1:N   
   ff=@(x)force_SNARE_memb_f1(x,Emax,xc,L1,L2,ratio,p,C(i),HC(i));
   % Calculate the equilibrium distance between membranes
   [d,value]=fzero(ff,f0);
   [V(i),f(i)]=membrane_potential_f1(d,Emax,xc,L1,L2,ratio);
   ext(i)=d;
   [r,k,e0]=Marko_Siggia(f(i),p);
   ext_C(i)=r.*C(i);
   E_SNARE(i)=E(i)+e0.*C(i);
   EA_SNARE(i)=EA(i)+e0.*C(i); 
   Etotal(i)=V(i)+E_SNARE(i);
   EAtotal(i)=V(i)+EA_SNARE(i);
   f0=f(i);
end

figure('name','Energy_force'); clf;

ax1=subplot('position',[0.1 0.1 0.85 0.2]);
plot(AA,ext,'-k',AA,HC,'-b',AA,C,'-r', AA,ext_C,'-g');
grid on 
ylabel('Extension (nm)')
xlabel('AA')
set(gca,'box','on');
legend({'Membrane distance','Hard core size','Contour length','Unfolded peptide length'})

ax2=subplot('position',[0.1 0.3 0.85 0.1]);
plot(AA,f,'-b');
ylabel('Force (pN)')
grid on
set(gca,'box','on','xticklabel','')

ax3=subplot('position',[0.1 0.4 0.85 0.52]);
plot(AA,Etotal,'-b',AA,E_SNARE,'-*r',AA,V,'-r',AA,E,'-k',AA,EAtotal,'--b',AA,EA_SNARE,'-*k',AA,EA,'--k');
grid on
set(gca,'box','on','xticklabel','')
ylabel('Energy (nm)')
legend({'Total SNARE-Membrane energy','SNARE energy','Membrane energy','Unloaded SNARE','Alternative total energy','Alternative SNARE energy','Alternative unloaded SNARE '})
linkaxes([ax1 ax2 ax3],'x')

figure('name','Energy, force vs distance'); clf;

ax1=subplot('position',[0.1 0.1 0.85 0.2]);
plot(ext,f,'-k');
grid on
ylabel('Force (pN)')
xlabel('Membrane distance (nm)')
set(gca,'box','on');

ax2=subplot('position',[0.1 0.3 0.85 0.6]);
plot(ext,V,'-r',ext,E_SNARE,'-r',ext,Etotal,'-b',ext,E,'-k',ext,EA_SNARE,'-r',ext,EAtotal,'--b',ext,EA,'--k');
ylabel('Energy (kT)')
grid on
legend({'Membrane energy','SNARE energy','Total energy','Unloaded SNARE','Alternative SNARE energy','Alternative total SNARE-membrane energy','Alternative unloaded SNARE energy'})

set(gca,'box','on','xticklabel','')
linkaxes([ax1 ax2],'x')
 
yp=[HC' ext_C'];
figure
[ax,h1,h2]=plotyy(ext',yp,ext',AA');
xlabel('Membrane distance (nm)')
set(gca,'box','on');
set(get(ax(1),'Ylabel'),'String','Length (nm)')
set(get(ax(2),'Ylabel'),'String','A.A. zippered')
linkaxes(ax,'x');
set(ax(1),'xlim',[0 13])
set(ax(2),'xticklabel','')


