function ext=ext_force_formula1(f,P)
% This function calculate the DNA extension when a pulling force is
% supplied, using Marko-Siggia formula. Note that the ext output is the ratio of DNA
% extension to DNA contour length.
r_start=1-0.5*sqrt(4.1/P/f);
if(r_start<0.2)
    r_start=0.1;
end

fun=inline('4.1./P.*(0.25./(1-x)^2+x-0.25)-f','x','P','f');
ff=@(x)fun(x,P,f);
[ext,value]=fzero(ff,r_start);
if(abs(value)>1e-6)
    disp('Root not found')
    disp(value)
end

