
function [V,f]=membrane_potential_f1(x,Emax,xc,L1,L2,ratio)
% The opposing energy of bringing two membranes at distance x
% x: distance, vector or scalar; in unit of nm
% Emax: Maximual energy barrier for membrane fusion at x=xc; unit is kT
% xc: starting point for expotential decay above this point
% L1: the short decaying length of the hard core. Unit nm
% L2: the long decaying length of the steric repusive force. Unit nm
% ratio: the ratio of amplitude for L2 to L1. 
% V: membrane potential in unit kT
% potentia V=A*(exp(-(x-xc)/L1)+ratioexp(-(x-xc)/L2))
% force f=A*(exp(-(x-xc)/L1)/L1+ratio*exp(-(x-xc)/L2)/L2) in the unit of pN
% A=Emax/(1+ratio); V(xc)=Emax.

V=zeros(size(x));
f=zeros(size(x));
kT=4.1;
A=kT.*Emax./(1+ratio);
xs=x-xc;
V=A.*(exp(-xs./L1)+ratio.*exp(-xs./L2));
V=V./kT;  % Convert from pNxnm to kT;
f=A.*(exp(-xs./L1)./L1+ratio.*exp(-xs./L2)./L2);

end


