function df=force_SNARE_memb_f1(d,Emax,xc,L1,L2,ratio,p,C,HC)
% Calculate the force difference between membrane opposing force and 
% the SNARE pulling force as a function of distance between
% membranes
% d: distance between membranes
% p: Persistence length 
% C: Contour length of the unfoled peptide
% HC: Hard core extension

% Energy and force between two membranes with a distance of d
  [V,f1]=membrane_potential_f1(d,Emax,xc,L1,L2,ratio);
  % Extension of the unfolded polypeptide
  mr=(C.^0.6).*(p.^0.4)/2; % SNARE mushroom size
  ext=d-HC-mr;  
  r=ext/C;
  if(r<1)
      fun=inline('4.1./P.*(0.25./(1-x)^2+x-0.25)','x','P');
      f2=fun(r,p);
      df=f1-f2;
  else
      df=-1000;
  end
end

