#!/bin/bash
#
# yeast_somatic_sniper.sh
#
export somatic_sniper_dir=somatic-sniper/bin
#
export fastq_dir=${1}
export sample=${2}
export ref_bam=${3}
export genome_dir=${4}
export genome_fa=${5}
export user=${6}
export ploidy=${7}
#
echo $sample
#
echo COPY GENOME TO TMP FOLDER
    rm -rf /tmp/$user/$sample 
    mkdir /tmp/$user
    mkdir /tmp/$user/$sample
    rsync -av $genome_dir/$genome_fa /tmp/$user/$sample
    rsync -av $fastq_dir/$ref_bam /tmp/$user/$sample
    export genome=/tmp/$user/$sample/$genome_fa
    export temp_ref_bam=/tmp/$user/$sample/$ref_bam
#
cd $fastq_dir
#
echo GENOME: $genome
echo REFERENCE: $temp_ref_bam
echo SAMPLE: $sample
echo ------------------------------------
#
$somatic_sniper_dir/bam-somaticsniper -q 30 -Q 15 -F vcf -N $ploidy \
              -f $genome \
              $fastq_dir/$sample.bam \
              $temp_ref_bam \
              $fastq_dir/$sample.somatic-sniper.vcf
#
echo REMOVE GENOME TMP FOLDER
    rm -rf /tmp/$user/$sample 
#
echo END END END # END END END
