pro batch_start, event
T=systime(1)

widget_control, event.top, GET_Uvalue=info
;check for the RTFM filter selection

if info.rtfm_filter EQ 0 then begin
    ;usage: PRO rtfm, filename, highFTarget, sliceArr, t_slice
    rtfm, info.Filename, res, outputID=info.outputlocalizeID
    a=where(res EQ 1)
    first=a[0]+1    ;the +1 is necessary to convert from the RTFM return value to our frame values
    last=a[0]+1
    endif
    
WIDGET_CONTROL, info.tableID, GET_VALUE=files
file_cull=files(where(files NE ''))
number_files= n_elements(file_cull)

;now run localize on EACH stack in the batch
if number_files GT 0 then begin
    for i= 0, number_files-1 do begin
    batch_filename=file_cull[i]   ;proceed to the next file
    res=query_tiff(file_cull[i], a)
    locparameters={$
      filename:batch_filename, $
      blacklevelID:info.blacklevelID, $
      first:1, $
      last:a.num_images, $    ;note: the current setup DOES ALL THE FRAMES IN EACH STACK
      channel:info.channel, $
      psfwidth:info.psfwidth, $
      cutsize:info.cutsize, $
      bpassthreshold:info.bpassthreshold, $
      auto_bpass_val:info.auto_bpass_val, $
      auto_black_level_val:info.auto_black_level_val, $
      autoBpassThreshold:info.autoBpassThreshold, $
      photonthreshold:info.photonthreshold, $
      tolerance:info.tolerance, $
      blacklevel:info.blacklevel, $
      outputlocalizeID:info.outputlocalizeID, $
      peak_white:info.peak_white, $
      algorithm:info.algorithm, $
      FCS_FRAP:info.FCS_FRAP, $
      maxdisp:info.maxdisp $
           }
           
   ;call localize.pro
    localize, locparameters, /batch
    endfor
endif
runtime=systime(1)-T
res=dialog_message(title='LOCALIZE batch processing complete', 'run time: '+string(runtime)+' seconds')
end

pro loc_batch_done, event
widget_control, event.top, /destroy
end

pro multiple_tif_Open, event

file = DIALOG_PICKFILE(/READ, FILTER = '*.tif', dialog_parent=event.top, /multiple_files, get_path=file_path)
if file[0] eq '' then return
cd, file_path
n=n_elements(file)
widget_control, event.top, GET_Uvalue=batch_info
WIDGET_CONTROL, batch_info.tableID, SET_VALUE=transpose(file), USE_TABLE_SELECT=[0,0,0,n-1]
return
end

PRO batch_setup, event

maxysize=1000

widget_control, event.top, GET_Uvalue=main_parameters
form = WIDGET_BASE(TITLE='Batch File Localization', xs=450, ys=515, group_leader=event.top,/column,/modal)
openID=widget_button(form, value='Open', Event_pro='multiple_tif_Open')
upID=widget_button(form,value='up', Event_pro='file_up', sensitive=0)
downID=widget_button(form, value='down', Event_pro='file_down', sensitive=0)

tableID = WIDGET_table(form,xsize=1, ysize=maxysize, scr_xsize=400, scr_ysize=350, $
    /scroll, /resizeable_columns, column_width=350)

channelBase=widget_base(form, /row)
textID=widget_label(channelBase, value='channel select:')
channelID=cw_bgroup(channelBase, ['1', '2'], column=2, /exclusive, event_func='channel_select', /no_release)
text1ID=widget_label(channelBase, value='(default = 1)')
batchstartID=widget_button(form, value='Begin Batch Localization', event_pro='batch_start')
doneID=widget_button(form, value='Done', event_pro='loc_batch_done')

WIDGET_CONTROL, form, /REALIZE

;get the values of the widgets in the main window
widget_control, main_parameters.firstID, get_value=first
widget_control, main_parameters.lastID, get_value=last
widget_control, main_parameters.psfwidthID, get_value=psfwidth
widget_control, main_parameters.cutsizeID, get_value=cutsize
widget_control, main_parameters.bpassthresholdID, get_value=bpassthreshold
widget_control, main_parameters.autoBpassthresholdID, get_value=autoBpassThreshold
widget_control, main_parameters.photonthresholdID, get_value=photonthreshold
widget_control, main_parameters.toleranceID, get_value=tolerance
widget_control, main_parameters.blacklevelID, get_value=blacklevel
widget_control, main_parameters.outputlocalizeID, set_value=' '
widget_control, main_parameters.maxdispID, get_value=maxdisp   ;This line is added for the FCS_FRAP spot finding module

batch_setup_info={$
    tableID:tableID, $
    outputlocalizeID:main_parameters.outputlocalizeID, $  
    channel:0, $ ;default value = channel 1 (i.e. the only channel in a single channel exp)                  
    filename:main_parameters.picFilename, $
    rtfm_filter:main_parameters.rtfm_filter, $
    blacklevelID:main_parameters.blacklevelID, $
    first:first, $
    last:last, $
    psfwidth:psfwidth, $
    cutsize:cutsize, $
    bpassthreshold:bpassthreshold, $
    auto_bpass_val:main_parameters.auto_bpass_val, $
    auto_black_level_val:main_parameters.auto_black_level_val, $
    autoBpassThreshold:autoBpassThreshold, $
    photonthreshold:photonthreshold, $
    tolerance:tolerance, $
    blacklevel:blacklevel, $
    peak_white:main_parameters.peak_white, $
    algorithm:main_parameters.algorithm, $
    FCS_FRAP:main_parameters.FCS_FRAP, $
    maxdisp:maxdisp $
 }

widget_control, form, Set_Uvalue=batch_setup_info, /no_copy


XMANAGER, 'batch_setup', form, /NO_BLOCK

return
end