pro bpassView, event, stack=stack
widget_control, event.top, GET_Uvalue=info
widget_control, info.referencechannelID, get_value=channel_color
if channel_color EQ 'red' then info.channel=0
if channel_color EQ 'green' then info.channel=1 
frame=info.frameindex
pic=read_tiff(info.picFilename, image_index=frame+info.channel)
a=size(pic, /dimensions)
x_dim=a[0]
y_dim=a[1]

if keyword_set(stack) then begin
    pic_size=size(pic, /dimensions)
    sum_pic=dblarr(x_dim, y_dim)

    ;read each frame and generate an averaged pic of the whole series

    widget_control, info.outputlocalizeID, set_value='AVERAGING...'
    for i=stack[0]-1, stack[1]-1 do begin
    pic=read_tiff(info.picFilename, image_index=i)
        sum_pic=sum_pic+double(pic)
       endfor
    pic=sum_pic/double(stack[1]-stack[0]+1)
    widget_control, info.outputlocalizeID, set_value='finished', /append
    endif

widget_control, info.psfwidthID, get_value=psfwidth
widget_control, info.bpassthresholdID, get_value=bpassthreshold
widget_control, info.autoBpassThresholdID, get_value=autoBpassThreshold

erase

;The autobass feature chooses a bpass value based on the standard deviation of the image.  If an ROI is selected,
;then the autobpass level reflects the standard deviation of the ROI.  Thus, ROI handling code
;needs to be insterted in this part of the bandpass routine.
;********************************************************************************
if info.auto_bpass_val EQ 0 then begin

    x0=0
    y0=0
    x1=x_dim-1
    y1=y_dim-1
    ;check if an ROI has been selected.
    ;The coniditional statement below needs an ROI of at least 1 dimension in both x and y
    check1=(info.selection_par[3] GE 0)       ;=1
    check2=(info.selection_par[4] GE 0)       ;=1
    check3=(info.selection_par[5] LT x_dim)   ;=1
    check4=(info.selection_par[6] LT y_dim)   ;=1
    check5=total(info.selection_par[3:6])      ; > 2 to be a defined ROI
    if (check1*check2*check3*check4*check5 GE 2) then begin
        x0=info.selection_par[3]
        x1=info.selection_par[5]
        y0=info.selection_par[4]
        y1=info.selection_par[6]
        endif

        temp_bpass=bpass(pic, 1, 2*psfwidth)
        tvscl, temp_bpass[x0:x1, y0:y1] GE autoBpassThreshold*stddev(temp_bpass[x0:x1, y0:y1]), x0, y0
        endif else tvscl, bpass(pic, 1., 2.*psfwidth) GE bpassthreshold

contrast_index=where(pic GE info.peak_white)
contrast_index=abs(contrast_index)
pic(contrast_index) = info.peak_white
tvscl, pic, 0, 0, 1+info.channel
widget_control, info.outputlocalizeID, set_value='bpass frame:'+string(frame+1)
info.selection_par=[-1, -1, -1, 0, 0, 0, 0]
widget_control, event.top, SET_uvalue=info, /no_copy
return
end


