pro assigncompositeMask, event
widget_control, event.top, GET_Uvalue=maskinfo
maskinfo.assignmultichannelmask=1   ;set the switch to look for a multichannel mask
widget_control, maskinfo.redfileID, get_value=red_filename
widget_control, maskinfo.greenfileID, get_value=green_filename
widget_control, maskinfo.bluefileID, get_value=blue_filename

widget_control, maskinfo.frameID, get_value=frame
widget_control, maskinfo.drawID, get_value=win1
wset, win1

red_pic=read_tiff(red_filename, image_index=frame)
green_pic=read_tiff(green_filename, image_index=frame)
blue_pic=read_tiff(blue_filename, image_index=frame)

IF ((res1 EQ -1) OR (res2 EQ -1) OR (res3 EQ -1)) then begin
       res=dialog_message('Cannot read IPLAB files', title='File error in assigncompositeMask')
       return
     endif
widget_control, maskinfo.redbpassID, get_value=redbpass
widget_control, maskinfo.redthresholdID, get_value=redthreshold
widget_control, maskinfo.greenbpassID, get_value=greenbpass
widget_control, maskinfo.greenthresholdID, get_value=greenthreshold
widget_control, maskinfo.bluebpassID, get_value=bluebpass
widget_control, maskinfo.bluelowerbpassID, get_value=bluelowerbpass
widget_control, maskinfo.bluethresholdID, get_value=bluethreshold
erase

bp_red=bpass(red_pic, 1., redbpass) GE redthreshold
bp_green=bpass(green_pic, 1., greenbpass) GE greenthreshold
bp_blue=bpass(blue_pic, bluelowerbpass, bluebpass) GE bluethreshold

compositemask=bp_red*bp_green*bp_blue
tvscl, compositemask

widget_control, event.top, Set_Uvalue=maskinfo, /no_copy
return
end

pro viewcompositeMask, event
widget_control, event.top, GET_Uvalue=maskinfo
widget_control, maskinfo.redfileID, get_value=red_filename
widget_control, maskinfo.greenfileID, get_value=green_filename
widget_control, maskinfo.bluefileID, get_value=blue_filename

widget_control, maskinfo.frameID, get_value=frame
widget_control, maskinfo.drawID, get_value=win1
wset, win1

red_pic=read_tiff(red_filename, image_index=frame)
green_pic=read_tiff(green_filename, image_index=frame)
blue_pic=read_tiff(blue_filename, image_index=frame)

IF ((res1 EQ -1) OR (res2 EQ -1) OR (res3 EQ -1)) then begin
       res=dialog_message('Cannot read IPLAB files', title='File error in viewcompositeMask')
       return
     endif
widget_control, maskinfo.redbpassID, get_value=redbpass
widget_control, maskinfo.redthresholdID, get_value=redthreshold
widget_control, maskinfo.greenbpassID, get_value=greenbpass
widget_control, maskinfo.greenthresholdID, get_value=greenthreshold
widget_control, maskinfo.bluebpassID, get_value=bluebpass
widget_control, maskinfo.bluelowerbpassID, get_value=bluelowerbpass
widget_control, maskinfo.bluethresholdID, get_value=bluethreshold
erase

;compositemask=(bpass(red_pic, 1., redbpass) GE redthreshold)*(bpass(green_pic, 1., greenbpass) GE greenthreshold)*$
;(bpass(blue_pic, 1., bluebpass) GE bluethreshold)
;tvscl, compositemask

bp_red=bpass(red_pic, 1., redbpass) GE redthreshold
bp_green=bpass(green_pic, 1., greenbpass) GE greenthreshold
bp_blue=bpass(blue_pic, bluelowerbpass, bluebpass) GE bluethreshold

if get_bit(maskinfo.channel, 1) then tvscl, bp_red, 0, 0, 1 else tvscl, red_pic, 0, 0, 1
if get_bit(maskinfo.channel, 2) then tvscl, bp_green, 0, 0, 2 else tvscl, green_pic, 0, 0, 2
if get_bit(maskinfo.channel, 3) then tvscl, bp_blue, 0, 0, 3 else tvscl, blue_pic, 0, 0, 3
return
end

FUNCTION redchannelView, event

;event = {ID:0L, TOP:0L, HANDLER:0L, SELECT:0, VALUE:0 }
;if event.value eq 0 then print, 'Gaussian Mask'
;if event.value eq 1 then print, 'Nonlinear Least Squares'
widget_control, event.top, get_uvalue=maskinfo
maskinfo.channel=set_bit(maskinfo.channel, 1, event.value)
;print, event.value
widget_control, event.top, set_uvalue=maskinfo, /no_copy
return, 1
end

FUNCTION greenchannelView, event
widget_control, event.top, get_uvalue=maskinfo
;print, event.value
maskinfo.channel=set_bit(maskinfo.channel, 2, event.value)
widget_control, event.top, set_uvalue=maskinfo, /no_copy
return, 1
end

FUNCTION bluechannelView, event
widget_control, event.top, get_uvalue=maskinfo
;print, event.value
maskinfo.channel=set_bit(maskinfo.channel, 3, event.value)
widget_control, event.top, set_uvalue=maskinfo, /no_copy
return, 1
end

PRO createMultiChannelMask, event
xs=300
ys=500
widget_control, event.top, GET_Uvalue=info

form = WIDGET_BASE(TITLE='Create Multi-Channel Mask', xsize=xs, ysize=ys, group_leader=event.top,/column, MBar=menubarID)
redparameterBase=widget_base(form, /frame, /col)
greenparameterBase=widget_base(form, /frame, /col)
blueparameterBase=widget_base(form, /frame, /col)
fileID=widget_button(menubarID, value='File', /menu)
viewID=widget_button(menubarID, value='View', /menu)
openredID=widget_button(fileID,value='Open red...', Event_pro='redchannel_open')
opengreenID=widget_button(fileID,value='Open green...', Event_pro='greenchannel_open')
openblueID=widget_button(fileID,value='Open blue...', Event_pro='bluechannel_open')
eraseID=widget_button(viewID, value='Clear window', Event_pro='clearwindow')
redfileID=cw_field(redparameterbase, title='red filename:', value='red filename')
redbpassID=cw_field(redparameterbase, title='red bpass', value=1.7, /floating)
redthresholdID=cw_field(redparameterbase, title='red threshold', value=200, /floating)

greenfileID=cw_field(greenparameterbase, title='green filename:', value='green filename')
greenbpassID=cw_field(greenparameterbase, title='green bpass', value=1.7, /floating)
greenthresholdID=cw_field(greenparameterbase, title='green threshold', value=200, /floating)

bluefileID=cw_field(blueparameterbase, title='blue filename:', value='blue filename')
bluelowerbpassID=cw_field(blueparameterbase, title='blue lower bpass', value=5.0, /floating)
bluebpassID=cw_field(blueparameterbase, title='blue upper bpass', value=20.0, /floating)
bluethresholdID=cw_field(blueparameterbase, title='blue threshold', value=200, /floating)

viewselectionBase=widget_base(form, /frame, /row)
redchannelviewID=cw_bgroup(viewselectionBase, ['red pic', 'red bpass'], /exclusive, event_func='redchannelView', /no_release)
greenchannelviewID=cw_bgroup(viewselectionBase, ['green pic', 'green bpass'], /exclusive, event_func='greenchannelView', /no_release)
bluechannelviewID=cw_bgroup(viewselectionBase, ['blue pic', 'blue bpass'], /exclusive, event_func='bluechannelView', /no_release)
viewmultichannelmaskID=widget_button(form, value='view', event_pro='viewcompositeMask')
assignmultichannelmaskID=widget_button(form, value='assign multichannel mask', event_pro='assigncompositeMask', sensitive=0)

frameID=cw_field(form, title='frame:', value=1, /floating)

;viewmultichannelmaskID=widget_button(form, value='view composite mask', event_pro='viewcompositeMask')

channel=0b
maskinfo={$
    drawID:info.drawID, $
    redfileID:redfileID, $
    redbpassID:redbpassID, $
    redfilename:'red temp', $
    redthresholdID:redthresholdID, $
    greenfileID:greenfileID, $
    greenbpassID:greenbpassID, $
    greenfilename:'green temp', $
    greenthresholdID:greenthresholdID, $
    bluefileID:bluefileID, $
    bluebpassID:bluebpassID, $
    bluelowerbpassID:bluelowerbpassID, $
    bluefilename: 'blue temp', $
    bluethresholdID:bluethresholdID, $
    frameID:frameID, $
    channel:channel, $        ;bit
    assignmultichannelmask:info.assignmultichannelmask $    ;0=no mask assigned, 1=multichannel mask assigned
          }

widget_control, form, Set_Uvalue=maskinfo, /no_copy

height = max(widget_height(form))
widget_control, redparameterbase, ysize=0.18*height
widget_control, greenparameterbase, ysize=0.18*height
widget_control, blueparameterbase, ysize=0.24*height
widget_control, viewselectionBase, ysize=0.15*height
;widget_control, drawBase, ysize=height

WIDGET_CONTROL, form, /REALIZE
XMANAGER, 'createMultichannelMask', form, /NO_BLOCK
end