PRO confirmROI, event

    widget_control, event.top, GET_Uvalue=info

    widget_control, info.lastID, get_value=last
    widget_control, info.psfwidthID, get_value=psfwidth
    widget_control, info.cutsizeID, get_value=cutsize
    widget_control, info.bpassthresholdID, get_value=bpassthreshold
    widget_control, info.autoBpassthresholdID, get_value=autoBpassThreshold
    widget_control, info.photonthresholdID, get_value=photonthreshold
    widget_control, info.toleranceID, get_value=tolerance
    widget_control, info.blacklevelID, get_value=blacklevel
    widget_control, info.outputlocalizeID, set_value=' '
    widget_control, info.maxdispID, get_value=maxdisp


    locparameters={$
	    filename:info.picFilename, $
	    blacklevelID:info.blacklevelID, $
	    first:info.roimanyIndex, $   ;we are only doing one frame at a time
	    last:info.roimanyIndex, $
	    psfwidth:psfwidth, $
	    cutsize:cutsize, $
	    bpassthreshold:bpassthreshold, $
	    auto_bpass_val:info.auto_bpass_val, $
	    auto_black_level_val:info.auto_black_level_val, $
	    autoBpassThreshold:autoBpassThreshold, $
	    photonthreshold:photonthreshold, $
	    tolerance:tolerance, $
	    blacklevel:blacklevel, $
	    outputlocalizeID:info.outputlocalizeID, $
	    peak_white:info.peak_white, $
	    FCS_FRAP:info.FCS_FRAP, $
	    composite:info.composite, $
	    channel:info.channel, $
	    num_images:info.num_images, $
      maxdisp:maxdisp, $
	    algorithm:info.algorithm $
     }
     
     ;take the selection parameters and put them in the form for localize
    region=intarr(4)
    region[0]=info.selection_par[3]
    region[1]=info.selection_par[4]
    region[2]=info.selection_par[5]-info.selection_par[3]
    region[3]=info.selection_par[6]-info.selection_par[4]

    ;erase the previous values and reset the ROI and increment the roimanyIndex
    info.selection_par=[-1, -1, -1, 0, 0, 0, 0]
    info.roimanyIndex=info.roimanyIndex+1

    ;turn off the confirm ROI button at the end of the runs
    dummy=info.roimanyIndex
    if info.roimanyIndex EQ last+1 then begin
        widget_control, info.confirmID, sensitive=0
    endif

    widget_control, event.top, SET_uvalue=info, /no_copy
    ;note: if you want the ROI to be kept from run to run, just remove the above line

    localize, locparameters, selection=region, /manyROI

    if dummy LT last+1 then begin  ;note: we have to use a dummy variable, because we have already
                                 ;returned the structure to the calling widget
       raw_image=read_tiff(locparameters.filename, image_index=dummy-1)
        tvscl, raw_image, 0, 0, 2

        widget_control, locparameters.outputlocalizeID, set_value='frame:'+string(dummy)
    endif else begin
        loc_filename=change_extension(locparameters.filename, 'loc')
        par_filename=change_extension(locparameters.filename, 'par')
       res=dialog_message(title='LOCALIZE complete', string(10b)+$
     'data written to: '+loc_filename+string(10b)+ $
     'parameters written to: '+par_filename+string(10b))
       endelse
return
end