FUNCTION cull_spot, spot_locations, parameters

; This function goes through a list of spots of the form:
; x1    y1 N1
; x2    y2 N2...

duplicate_points=0.0
a=size(spot_locations)

; if there is only one spot, return to main program
if(a[0] EQ 1) then return, spot_locations

;sort spot_locations in descending order based on photon number
sort_index=sort(spot_locations[2, *])
sort_spot_locations=spot_locations[*, reverse(sort_index)]
;*sorting the spot locations has the effect in the following loop that the DIMMER spot
;is discarded if there is a question about spots which are too close together

for i=0l, a[2]-2 do begin
x=sort_spot_locations[0, i]
y=sort_spot_locations[1, i]
N=sort_spot_locations[2, i]
if ((x EQ 0) AND (y EQ 0)) then duplicate_points=duplicate_points+1 else begin
for j= i+1, a[2]-1 do begin
if ((sort_spot_locations[0, j] - x)^2 + (sort_spot_locations[1, j]-y)^2) LT parameters.tolerance^2 then begin
        sort_spot_locations[0, j] = 0.0
        sort_spot_locations[1, j] = 0.0
        sort_spot_locations[2, j] = 0.0
        endif
    endfor
endelse
endfor
if ((sort_spot_locations[0, a[2]-1] EQ 0) AND (sort_spot_locations[1, a[2]-1] EQ 0)) then begin
duplicate_points=duplicate_points+1     ; this line is necessary to satisfy the endpoints
endif
;print, "duplicate/discarded spots: ", duplicate_points
if(duplicate_points EQ a[2]) then return, [0,0,0]
culled_list=sort_spot_locations(where(sort_spot_locations))
culled_list=reform(culled_list, 3, a[2]-duplicate_points)
return, culled_list
end