pro denoise

;file = DIALOG_PICKFILE(/READ, FILTER = '*.tif', get_path=file_path)
;if file[0] eq '' then return
;cd, file_path
frames=102
color_merge=bytarr(3, 200, 100)
write_tiff, 'bpass3.tif', color_merge 
max_red=0.0
max_green=0.0
for i=0, frames do begin
  green_pic=read_tiff('20140115_YTL117B gal induction 30s ND1.5 _2_reg_sc_crop.tif', image_index=2*i+1)
  red_pic=read_tiff('20140115_YTL117B gal induction 30s ND1.5 _2_reg_sc_crop.tif', image_index=2*i)
  red_bpass= bpass(red_pic, 1, 3)^2
  green_bpass= bpass(green_pic, 1, 3)^2 
  ;IF (A GT B) THEN Z = A ELSE Z = B
  ;This statement can be written more concisely using a conditional expression:
  ;Z = (A GT B) ? A : B
  
  max_red=(max_red GT max(red_bpass)) ? max_red : max(red_bpass)
  max_green=(max_green GT max(green_bpass)) ? max_green : max(green_bpass)
  endfor
for i=0, frames do begin
  green_pic=read_tiff('20140115_YTL117B gal induction 30s ND1.5 _2_reg_sc_crop.tif', image_index=2*i+1)
  red_pic=read_tiff('20140115_YTL117B gal induction 30s ND1.5 _2_reg_sc_crop.tif', image_index=2*i)
  red_bpass= bpass(red_pic, 1, 3)^2
  green_bpass= bpass(green_pic, 1, 3)^2 
  nuc_bpass=roberts(bpass(red_pic, 5, 20) GE 100)
  tvscl, red_pic, 0, 200, 1
  tvscl, green_pic, 0, 200, 2
  tv, bytscl(red_bpass), 0, 100, 1
  tv, bytscl(green_bpass), 0, 100, 2
  
  color_merge[0, *, *]=byte(red_bpass*255.0/max_red)
  color_merge[1, *, *]=byte(green_bpass*255.0/max_green )
  color_merge[2, *, *]=bytscl(nuc_bpass)
  tv, color_merge, /true
 write_tiff, 'bpass3.tif', color_merge, /append
  r=get_kbrd()
 
  endfor

return
end

