PRO DualtrackButton, event

;get the global strucutre
widget_control, event.top, GET_Uvalue=info

    widget_control, info.maxdispID, get_value=maxdisp
    widget_control, info.iniposxID, get_value=iniposx
    widget_control, info.iniposyID, get_value=iniposy
    widget_control, info.track_memoryID, get_value=track_memory
    widget_control, info.dimID, get_value=dim
    widget_control, info.goodenoughID, get_value=goodenough


trackparameters={$
    locFilename:info.locFilename, $
    maxdisp:maxdisp, $
    iniposx:iniposx, $
    iniposy:iniposy, $
    track_memory:track_memory, $
    dim:dim, $
    goodenough:goodenough, $
    outputlocalizeID:info.outputlocalizeID $
     }

res=track(trackparameters)
;print, trackparameters
if res[0] eq -1 then begin
  ret=dialog_message('Track did not finish.  Adjust Parameters.  Try again.', title='Error in DualtrackButton.')
  return
  endif
  
;Now, re-arrange the loc files into two loc files and save them
total_trk=read_trk(change_extension(info.locFilename, 'trk'))
even=where(total_trk[3,*] mod 2 eq 0) ;also includes the 0 frame
odd=where(total_trk[3, *] mod 2 eq 1)
even_frames=n_elements(even)
odd_frames=n_elements(odd)
if even_frames NE odd_frames then res=dialog_message("The two channels do not have the same number of frames."+string(10B)+$
"Check source TRK file.", title="Error in localizedualbutton.pro")
 
trk_even=total_trk[*, even]
trk_odd=total_trk[*, odd]
red_split_trk_file=strmid(info.locFilename, 0, strpos(info.locFilename, '.'))+'_red.trk'
green_split_trk_file=strmid(info.locFilename, 0, strpos(info.locFilename, '.'))+'_green.trk'
openw, 4, red_split_trk_file
openw, 5, green_split_trk_file

for i=0, even_frames-1 do begin
  printf, 4, FORMAT = '(5(f11.3, "    "))',  trk_even[0, i], trk_even[1, i], trk_even[2, i], i, trk_even[4, i]
  endfor
  close, 4
for i=0, odd_frames-1 do begin 
  printf, 5, FORMAT = '(5(f11.3, "    "))',  trk_odd[0, i], trk_odd[1, i], trk_odd[2, i], i, trk_odd[4, i]
  endfor
  close, 5
  
  res=dialog_message('LOC files split into:'+ string(10B)+red_split_trk_file+string(10B)+green_split_trk_file, title='localize dual mode complete.')
  
  return
  end
  