PRO convert_filename, event
filename='a'
widget_control, event.id, GET_VALUE=filename
widget_control, event.id, SET_value=strupcase(filename)
end

pro tif_pic_convert, event

;TIF_PIC reads in a batch of tif files generated by Amber's tracking routine and converts
;them to a .pic format which can be read by confocal assistant or the tracking routine.
;
;Daniel Larson
;4/20/04
pic_filename='unnamed.pic'
widget_control, event.top, GET_Uvalue=tif_pic_info
widget_control, tif_pic_info.filenameID, get_value=pic_filename
widget_control, tif_pic_info.tableID, get_value=files
file_cull=files(where(files NE ''))
frames= n_elements(file_cull)

pic=uint((read_tiff(file_cull[0])))
res=write_pic(pic_filename, pic, frames, /open)
if res eq -1 then begin
    res=dialog_message('File conversion error.  Try a different filename.', title='File error in TIF_PIC_CONVERT')
    return
    endif

if frames GT 0 then begin
    ;this loop APPENDS the subsequent time points
    for i= 1, frames-1 do begin
        pic=uint((read_tiff(file_cull[i])))
        res=write_pic(pic_filename, pic, frames, /append)
        endfor
        endif

;now close the generated pic file
res=write_pic(pic_filename, pic, frames, /close)
res=dialog_message('File written to:'+pic_filename, title='Conversion complete')
return
end

pro tif_ipl_convert, event

;TIF_IPL reads in a batch of tif files or a single tif multiframe file and converts
;them to a .ipl format which can be read by confocal assistant or the tracking routine.
;
;Daniel Larson
;4/20/04
pic_filename='unnamed.pic'
widget_control, event.top, GET_Uvalue=tif_pic_info
widget_control, tif_pic_info.filenameID, get_value=pic_filename
widget_control, tif_pic_info.tableID, get_value=files

file_cull=files(where(files NE ''))
number_stacks= n_elements(file_cull)

;check the first tif for a multiframe image stack
;In this construction the conversion utility automatically determines whether we
;have a multiframe image stack or a collection of individual images
res=query_tiff(file_cull[0], a)

frames = a.num_images+number_stacks-1
pic=uint((read_tiff(file_cull[0])))

dim_check=size(pic, /dimensions)
if n_elements(dim_check) GT 2 then begin
	if tif_pic_info.channel_select_convert EQ 0 then dummy='red'
	if tif_pic_info.channel_select_convert EQ 1 then dummy='green'
	if tif_pic_info.channel_select_convert EQ 2 then dummy='blue'
	res=dialog_message('This file is a color tiff.'+STRING(10B)+$
	'Conversion will ONLY use the '+dummy+' channel.', title='File error in TIF_IPL_CONVERT')
	pic=reform(pic[tif_pic_info.channel_select_convert, *, *], dim_check[1], dim_check[2])
	endif

info={pic:pic, filename:pic_filename, zplanes:1, tvolumes:frames}

res=write_ipl(info, /open)
if res eq -1 then begin
    res=dialog_message('File conversion error.  Try a different filename.', title='File error in TIF_IPL_CONVERT')
    close, 4
    return
    endif

if frames GT 0 then begin
    ;this loop APPENDS the subsequent time points for the first tiff in the stack
    for i= 0, a.num_images-1 do begin
        pic=uint((read_tiff(file_cull[0], image_index=i)))
        if n_elements(dim_check) GT 2 then pic=reform(pic[tif_pic_info.channel_select_convert, *, *], dim_check[1], dim_check[2])
        info.pic=pic
        res=write_ipl(info, /append)
        endfor

	if number_stacks GT 1 then begin
		for j=1, number_stacks-1 do begin
		pic=uint((read_tiff(file_cull[j], image_index=0)))
		if n_elements(dim_check) GT 2 then pic=reform(pic[tif_pic_info.channel_select_convert, *, *], dim_check[1], dim_check[2])
        info.pic=pic
		res=write_ipl(info, /append)
		endfor
		endif
		endif

;now close the generated pic file
res=write_ipl(info, /close)
res=dialog_message('File written to:'+pic_filename, title='Conversion complete')
return
end

pro lsm_ipl_convert, event

widget_control, event.top, GET_Uvalue=lsm_pic_info
widget_control, lsm_pic_info.outputlocalizeID, set_value=' ' ;clear the window
widget_control, lsm_pic_info.tableID, get_value=files
file_cull=files(where(files NE ''))
number_stacks= n_elements(file_cull)

;In this conversion utility, unlike the tif --> ipl converstion utility, each LSM
;image is assumed to be an image stack.  Therefore, each file is converted to it's own
;IPL file rather than concatenating them togeher into one time series

for i=0, number_stacks-1 do begin
	raw_pic=uint(lsm_read(file_cull[i]))
	if raw_pic[0] EQ 65535 then begin
		res=dialog_message('File conversion error.  Unable to read lsm file.', title='File error in  LSM_IPL_CONVERT')
		return
		endif
	a=size(raw_pic, /dimensions)

if n_elements(a EQ 3) then begin		;the LSM file format is annoying.  For multi channel data, the pic data is 4 dimensional.
	pic=uintarr(a[0], a[1], 1, a[2])	;For single channel data, the pic is 3 dimensional.
	pic[*, *, 0, *]=raw_pic[*, *, *]	;Make ALL the pic matrices 3 dimensionsal.
	endif else pic=raw_pic

	a=size(pic, /dimensions)
	frames=a[3]

s=strlen(file_cull[i])
base_file=strmid(file_cull[i], 0, s-4)
CASE lsm_pic_info.channel OF			;by using the CASE format, it will be easier to scale up to more channels
	0: pic_filename=base_file+'_ch1.ipl'
	1: pic_filename=base_file+'_ch2.ipl'
	ENDCASE
	info={pic:pic[*,*,0,0], filename:pic_filename, zplanes:1, tvolumes:frames}	;The first pic is not written during
	res=write_ipl(info, /open)													;the write_ipl(info, /open) operation.
																				;It is a place holder.
	widget_control,lsm_pic_info.outputlocalizeID, set_value=pic_filename, /append
		for j= 0, frames-1 do begin
			CASE lsm_pic_info.channel OF
			0:info.pic=pic[*,*,0,j]
			1:info.pic=pic[*,*,1,j]
			ENDCASE
    		res=write_ipl(info, /append)
        	endfor

		;now close the generated pic file
		res=write_ipl(info, /close)
		endfor

output_dir=strmid(base_file, 0, strpos(base_file, '\', /reverse_search))
res=dialog_message('All files written with base directory:'+string(10B)+output_dir, title='Conversion complete')

return
end


FUNCTION channelSelectConvert, event
widget_control, event.top, GET_Uvalue=tif_pic_info
;event = {ID:0L, TOP:0L, HANDLER:0L, SELECT:0, VALUE:0 }
;if event.value eq 0 then print, 'Red'
;if event.value eq 1 then print, 'Green'
;if event.value eq 2 then print, 'Blue'
tif_pic_info.channel_select_convert=event.value
widget_control, event.top, set_uvalue=tif_pic_info, /no_copy
return, 1
end

pro file_up, event
widget_control, event.top, GET_Uvalue=tif_pic_info

;get all the values
WIDGET_CONTROL, tif_pic_info.tableID, GET_VALUE=whole_table
all=whole_table(where(whole_table NE '', count))
WIDGET_CONTROL, tif_pic_info.tableID, GET_VALUE=original, /use_table_select
selected=replicate(original, count)
index_arr=where(selected eq all)    ;location of the value of interest
index=index_arr[0]

if index GT 0 then begin
    widget_control, tif_pic_info.tableID, get_value=above, use_table_select=[0,index-1,0, index-1]
    widget_control, tif_pic_info.tableID, set_value=original, use_table_select=[0,index-1,0,index-1]
    widget_control, tif_pic_info.tableID, set_value=above, use_table_select=[0,index,0,index]
    endif
return
end

pro file_down, event

widget_control, event.top, GET_Uvalue=tif_pic_info

;get all the values
WIDGET_CONTROL, tif_pic_info.tableID, GET_VALUE=whole_table
all=whole_table(where(whole_table NE '', count))
WIDGET_CONTROL, tif_pic_info.tableID, GET_VALUE=original, /use_table_select
selected=replicate(original, count)
index_arr=where(selected eq all)    ;location of the value of interest
index=index_arr[0]

if index LT count-1 then begin
    widget_control, tif_pic_info.tableID, get_value=below, use_table_select=[0,index+1,0, index+1]
    widget_control, tif_pic_info.tableID, set_value=original, use_table_select=[0,index+1,0,index+1]
    widget_control, tif_pic_info.tableID, set_value=below, use_table_select=[0,index,0,index]
    endif
return
end

pro multiple_Open, event

file = DIALOG_PICKFILE(/READ, FILTER = '*.tif', dialog_parent=event.top, /multiple_files, get_path=file_path)
if file[0] eq '' then return
cd, file_path
n=n_elements(file)
widget_control, event.top, GET_Uvalue=tif_pic_info
WIDGET_CONTROL, tif_pic_info.tableID, SET_VALUE=transpose(file), USE_TABLE_SELECT=[0,0,0,n-1]
return
end

pro multiple_lsm_Open, event

file = DIALOG_PICKFILE(/READ, FILTER = '*.lsm', dialog_parent=event.top, /multiple_files, get_path=file_path)
if file[0] eq '' then return
cd, file_path
n=n_elements(file)
widget_control, event.top, GET_Uvalue=lsm_ipl_info
WIDGET_CONTROL, lsm_ipl_info.tableID, SET_VALUE=transpose(file), USE_TABLE_SELECT=[0,0,0,n-1]
return
end

pro tif_pic_done, event
widget_control, event.top, /destroy
end

pro lsm_pic_done, event
widget_control, event.top, /destroy
end

pro ipl_pic_open, event

file = DIALOG_PICKFILE(/READ, FILTER = '*.ipl', dialog_parent=event.top)

if file eq '' then return
ipl_pic, file
return
end

pro ipl_pic, filename

;IPL_PIC reads in a batch of IPL-forma files and converts
;them to a .pic format which can be read by confocal assistant or the tracking routine.
;
;Daniel Larson
;5/5/04

framestructure= read_ipl(filename, pic, 0, /frameinfo)
frames=uint(framestructure.tvolumes*framestructure.zplanes)
print, frames
IF (frames LT 0) then begin
       res=dialog_message('Cannot read ipl file.  Error in FRAMES assignment.', title='File error in LOCALIZE')
       return
     endif

;make a new filename for the output file
pic_filename=filename
s=strpos(filename, '.ipl')
if s eq -1 then s=strpos(filename, '.IPL')
strput, pic_filename, '.pic', s

;read the IPL file and initialize the output file
res=read_ipl(filename, pic, 0)
IF (res EQ -1) then begin
       res=dialog_message('Cannot read ipl file', title='File error in LOCALIZE')
       return
     endif

;find the global min and max of the series
;min_pic=32000
;max_pic=0
;for i=0U, frames-1 do begin
;    res=read_ipl(filename, pic, i)
;
;;IF (A GT B) THEN Z = A ELSE Z = B
;;This statement can be written more concisely using a conditional expression:
;;Z = (A GT B) ? A : B
;    min_pic = (min(pic) LT min_pic) ? min(pic) : min_pic
;    max_pic = (max(pic) GT max_pic) ? max(pic) : max_pic
;    endfor
;    ;print, min_pic, max_pic
;
res=write_pic(pic_filename, pic, frames, /open)

;this loop APPENDS the subsequent time points
for i= 1U, frames-1 do begin
    res=read_ipl(filename, pic, i)
    res=write_pic(pic_filename, pic, frames, /append)
    endfor

;now close the generated pic file
res=write_pic( pic_filename, pic, frames, /close)
res=dialog_message('IPL file converted to:'+pic_filename+string(10B)+'frames:'+string(frames),$
     title='Conversion complete')
return
end

pro tif_pic, event

maxysize=1000

form = WIDGET_BASE(TITLE='tif --> pic', xs=350, ys=500, group_leader=event.top,/column,/modal)
openID=widget_button(form, value='Open', Event_pro='multiple_Open')
upID=widget_button(form,value='up', Event_pro='file_up')
downID=widget_button(form, value='down', Event_pro='file_down')

tableID = WIDGET_table(form,xsize=1, ysize=maxysize, scr_xsize=300, scr_ysize=350, $
    /scroll, /resizeable_columns, column_width=250)

filenameID=widget_text(form, value='Enter new filename (*.pic).', event_pro='convert_filename', /editable)
convertID=widget_button(form, value='Convert', event_pro='tif_pic_convert')
doneID=widget_button(form, value='Done', event_pro='tif_pic_done')

WIDGET_CONTROL, form, /REALIZE

tif_pic_info={$
             tableID:tableID, $
             filenameID:filenameID $
           }

widget_control, form, Set_Uvalue=tif_pic_info, /no_copy


XMANAGER, 'tif_pic', form, /NO_BLOCK

return
end

pro tif_ipl, event

maxysize=1000

form = WIDGET_BASE(TITLE='tif --> ipl', xs=350, ys=550, group_leader=event.top,/column,/modal)
openID=widget_button(form, value='Open', Event_pro='multiple_Open')
upID=widget_button(form,value='up', Event_pro='file_up')
downID=widget_button(form, value='down', Event_pro='file_down')
channel_select_ConvertID=cw_bgroup(form, ['red', 'green', 'blue'], /exclusive, event_func='channelSelectConvert', /no_release, /row)


tableID = WIDGET_table(form,xsize=1, ysize=maxysize, scr_xsize=300, scr_ysize=350, $
    /scroll, /resizeable_columns, column_width=250)

filenameID=widget_text(form, value='Enter new filename (*.ipl).', event_pro='convert_filename', /editable)
convertID=widget_button(form, value='Convert', event_pro='tif_ipl_convert')
doneID=widget_button(form, value='Done', event_pro='tif_pic_done')

WIDGET_CONTROL, form, /REALIZE

tif_pic_info={$
             tableID:tableID, $
             channel_select_convert:1, $	;default='green'
             filenameID:filenameID $
           }

widget_control, form, Set_Uvalue=tif_pic_info, /no_copy


XMANAGER, 'tif_ipl', form, /NO_BLOCK

return
end

function channel_select, event
widget_control, event.top, get_uvalue=parameters
parameters.channel=event.value
;if event.value eq 0 then print, 'channel 1'
;if event.value eq 1 then print, 'channel 2'
;if event.value eq 2 then print, 'both'

widget_control, event.top, set_uvalue=parameters, /no_copy

return, 1
end

pro lsm_ipl, event

maxysize=1000

widget_control, event.top, GET_Uvalue=main_parameters
form = WIDGET_BASE(TITLE='lsm  --> ipl', xs=450, ys=515, group_leader=event.top,/column,/modal)
openID=widget_button(form, value='Open', Event_pro='multiple_lsm_Open')
upID=widget_button(form,value='up', Event_pro='file_up')
downID=widget_button(form, value='down', Event_pro='file_down')

tableID = WIDGET_table(form,xsize=1, ysize=maxysize, scr_xsize=400, scr_ysize=350, $
    /scroll, /resizeable_columns, column_width=350)

channelBase=widget_base(form, /row)
textID=widget_label(channelBase, value='channel select:')
channelID=cw_bgroup(channelBase, ['1', '2'], column=2, /exclusive, event_func='channel_select', /no_release)
text1ID=widget_label(channelBase, value='(default = 1)')
convertID=widget_button(form, value='Convert', event_pro='lsm_ipl_convert')
doneID=widget_button(form, value='Done', event_pro='lsm_pic_done')

WIDGET_CONTROL, form, /REALIZE

lsm_ipl_info={$
             tableID:tableID, $
             outputlocalizeID:main_parameters.outputlocalizeID, $
             channel:0 $	;default value = channel 1 (i.e. the only channel in a single channel exp)
           }

widget_control, form, Set_Uvalue=lsm_ipl_info, /no_copy


XMANAGER, 'lsm_ipl', form, /NO_BLOCK

return
end