FUNCTION find_spot, pic, parameters

; This routine finds candidates for spots and cuts those spots to send to other programs.
; Dan Larson 8/15/00

a=size(pic, /dimensions)
x_pixel=a[0]          ; these are the pixel dimensions
y_pixel=a[1]
above=bytarr(x_pixel, y_pixel)
closemask=bytarr(x_pixel, y_pixel)

cut_width=round(parameters.cutsize*parameters.psfwidth)
cut_spot={spot_number:0l, deltax:0.0, deltay:0.0, $
    spot_image:dblarr(2.0*cut_width+1, 2.0*cut_width+1)}   ; structure that constitutes the cut spot

; search for bright spots and create a binary mask of bright spot locations. then zero the border.

;check for the autobpass threshold selection
if parameters.auto_bpass_val EQ 0 then begin
    temp_bpass=bpass(pic, 1, 2*parameters.psfwidth)
    above= temp_bpass GE parameters.autoBpassThreshold*stddev(temp_bpass)
;    print, parameters.autoBpassThreshold*stddev(temp_bpass)
    endif

if parameters.auto_bpass_val EQ 1 then begin
    above = bpass(pic, 1, 2*parameters.psfwidth) GE parameters.bpassthreshold
;    print, parameters.bpassthreshold
    endif

above[0:cut_width, 0:y_pixel-1]=0
above[x_pixel-cut_width-1:x_pixel-1, 0:y_pixel-1]=0
above[0:x_pixel-1, 0:cut_width]=0
above[0:x_pixel-1, y_pixel-cut_width-1:y_pixel-1]=0

count=total(above)

if (count LT 1) then begin
cut_spot_array=replicate(cut_spot, 1)
cut_spot_array[0].spot_number=0
return, cut_spot_array
endif

pos=where(above EQ 1)
cut_spot_array=replicate(cut_spot, count)

for i=0L, count-1 do begin
x=pos[i] mod x_pixel
y=pos[i] / x_pixel
cut_spot_array[i].spot_image=pic[x-cut_width:x+cut_width, y-cut_width:y+cut_width]
cut_spot_array[i].deltax=x-cut_width
cut_spot_array[i].deltay=y-cut_width
cut_spot_array[i].spot_number = count
endfor
return, cut_spot_array
end