FUNCTION compare_click_to_file, filename, frame, x, y, composite

;note: on 10/9/07 LE was changed to LT in the first conditional statement
loc=read_loc(filename)
if (loc[0] LT 0) then begin
    res=dialog_message('Open a loc file before selecting a spot with right click.', title='Error in compare_click_to_file')
    return, -1
    endif
    
index=where(loc[3, *] EQ frame/(composite+1))

if index[0] LT 0 then begin
    res=dialog_message('Frame number does not match image number.', title='Error in compare_click_to_file')
    return, -1
    endif

xdiff=abs(loc[0, index]-x)
ydiff=abs(loc[1, index]-y)

sumdiff=xdiff+ydiff
sumdiff_min=min(sumdiff, pos)

;if xpos NE ypos then begin
;    res=dialog_message('The x min and the y min are not in the same position.', title='Problem in compare_click_to_file')
;    return, -1
;    endif
pos=pos+min(index) ;this line is necessary to account for instances where there are more than 1 frame
return, [loc[0, pos], loc[1, pos], loc[2, pos]]
end

PRO absFrame, event
widget_control, event.id, Get_value=temp
frame=long(temp-1L)
widget_control, event.top, GET_Uvalue=info
file=info.picfilename
loc_file=info.locFilename
widget_control, info.drawID, get_value=win1
widget_control, info.referencechannelID, get_value=channel_color
if channel_color EQ 'red' then info.channel=1
if channel_color EQ 'green' then info.channel=2
wset, win1

if info.composite EQ 0 then begin
  frame = (frame GT Info.num_images-1) ? Info.num_images-1 : frame
  frame = (frame LT 0) ? 0 : frame
  pic=read_tiff(file, image_index=frame)  ;frame comes from the text widget
  erase
  ;tvscl, 0*pic, 0, 0, 1
  contrast_index=where(pic GE info.peak_white)
  contrast_index=abs(contrast_index)
  pic(contrast_index) = info.peak_white
  tvscl, pic, 0,0, info.channel
  widget_control, info.outputlocalizeID, set_value='frame:'+string(frame+1)
  info.frameindex=frame
  endif
  
if info.composite EQ 1 then begin
  frame = (frame GT (Info.num_images-4)/2) ? (Info.num_images-4)/2 : frame
  frame = (frame LT 0) ? 0 : frame
  pic_red=read_tiff(file, image_index=2*frame)  ;frame comes from the text widget
  pic_green=read_tiff(file, image_index=2*frame+1)  ;frame comes from the text widget
  erase
  ;tvscl, 0*pic_red, 0, 0, 1
  contrast_index=where(pic_red GE info.peak_white)
  contrast_index=abs(contrast_index)
  pic_red(contrast_index) = info.peak_white
  tvscl, pic_red, 0,0, 1
  tvscl, pic_green, 0,0, 2
  widget_control, info.outputlocalizeID, set_value='frame:'+string(frame+1)
  info.frameindex=2*frame
  endif
  
  ;Now read the loc file
if loc_file NE 'temp' then begin
  loc=read_loc(loc_file)
  if (loc[0] LT 0) then begin
      res=dialog_message('Cannot read file.', title='Error in asbFrame')
      return
      endif
      index=where(loc[3, *] EQ frame[0], count)
  int_loc=round(loc)
  widget_control, info.outputlocalizeID, set_value='spots:'+string(count), /append
  
  if index[0] LT 0 then begin
    int_loc[*]  = [0.0, 0.0, 0.0, frame]
    count = 1
    ;  res=dialog_message('Frame number does not match image number.'+string(10B)+$
    ;  'Try setting frame='+string(loc[3, 0]+1), title='Error in absFrame')
    ;  return
      endif
  
  square_mask=bytarr(info.xtot, info.ytot)
  half_square=5
  for k = 0, count-1 do begin
    left_x=int_loc[0,index[k]]-half_square GT 0 ? int_loc[0,index[k]]-half_square : 0
    right_x=int_loc[0,index[k]]+half_square LT info.xtot-1 ? int_loc[0,index[k]]+half_square : info.xtot-1
    bottom_y=int_loc[1, index[k]]-half_Square GT 0 ? int_loc[1, index[k]]-half_Square : 0
    top_y= int_loc[1, index[k]]+half_square LT info.ytot-1 ? int_loc[1, index[k]]+half_square : info.ytot-1
    square_mask(left_x, bottom_y:top_y)=1
    square_mask(right_x, bottom_y:top_y)=1
    square_mask(left_x:right_x, top_y)=1
    square_mask(left_x:right_x, bottom_y)=1
    endfor
  s=replicate(1, 3, 3)
  if channel_color EQ 'red' then begin
    tvscl, square_mask, 0, 0, 3
    tvscl, square_mask, 0, 0, 2
    endif
    
  if channel_color EQ 'green' then begin
    tvscl, square_mask, 0, 0, 3
    tvscl, square_mask, 0, 0, 1
    endif
  endif
  
widget_control, event.top, SET_Uvalue=info, /no_copy
end

PRO incrementImage, event
widget_control, event.top, GET_Uvalue=info
frame=info.frameindex
file=info.picfilename
loc_file=info.locFilename
widget_control, info.drawID, get_value=win1
widget_control, info.referencechannelID, get_value=channel_color
if channel_color EQ 'red' then info.channel=1
if channel_color EQ 'green' then info.channel=2
wset, win1

if info.composite EQ 0 then begin   ;the case of a single image channel (i.e. no composite)
  frame=frame+1
  frame = (frame GT info.num_images-1) ? info.num_images-1 : frame
  pic=read_tiff(file, image_index=frame)
  ;blank=pic
  ;blank[*, *]=0
  erase
  ;tvscl, blank, 0, 0, 1
  contrast_index=where(pic GE info.peak_white)
  contrast_index=abs(contrast_index)
  pic(contrast_index) = info.peak_white
  tvscl, pic, 0,0, info.channel
  widget_control, info.outputlocalizeID, set_value='frame:'+string(frame+1)
  endif
  
if info.composite EQ 1 then begin ;the case of a two-channel composite image
  frame=frame+2
  frame = (frame GT info.num_images-4) ? info.num_images-4 : frame
  pic_red=read_tiff(file, image_index=frame)
  pic_green=read_tiff(file, image_index=frame+1)
  ;blank=pic_red
  ;blank[*, *]=0
  erase
  ;tvscl, blank, 0, 0, 1
  contrast_index=where(pic_red GE info.peak_white)
  contrast_index=abs(contrast_index)
  pic_red(contrast_index) = info.peak_white
  tvscl, pic_red, 0,0, 1
  tvscl, pic_green, 0, 0, 2
  widget_control, info.outputlocalizeID, set_value='frame:'+string((frame+2)/2)
endif

;Now read the loc file
if loc_file NE 'temp' then begin
  loc=read_loc(loc_file)
  if (loc[0] LT 0) then begin
      res=dialog_message('Cannot read file.', title='Error in incrementImage')
      return
      endif
      
   if info.composite EQ 0 then begin 
    index=where(loc[3, *] EQ frame, count)
    int_loc=round(loc)
    widget_control, info.outputlocalizeID, set_value='spots:'+string(count), /append
    if index[0] LT 0 then begin
      int_loc[*]  = [0.0, 0.0, 0.0, frame]
      count = 1
    endif
    endif
    
    if info.composite EQ 1 then begin 
      index=where(loc[3, *] EQ frame/2, count)
      int_loc=round(loc)
      widget_control, info.outputlocalizeID, set_value='spots:'+string(count), /append
      if index[0] LT 0 then begin
        int_loc[*]  = [0.0, 0.0, 0.0, frame/2]
        count = 1
      endif
   endif 
  
  square_mask=bytarr(info.xtot, info.ytot)
  half_square=5
  for k = 0, count-1 do begin
    left_x=int_loc[0,index[k]]-half_square GT 0 ? int_loc[0,index[k]]-half_square : 0
    right_x=int_loc[0,index[k]]+half_square LT info.xtot-1 ? int_loc[0,index[k]]+half_square : info.xtot-1
    bottom_y=int_loc[1, index[k]]-half_Square GT 0 ? int_loc[1, index[k]]-half_Square : 0
    top_y= int_loc[1, index[k]]+half_square LT info.ytot-1 ? int_loc[1, index[k]]+half_square : info.ytot-1
    square_mask(left_x, bottom_y:top_y)=1
    square_mask(right_x, bottom_y:top_y)=1
    square_mask(left_x:right_x, top_y)=1
    square_mask(left_x:right_x, bottom_y)=1
    endfor
  s=replicate(1, 3, 3)
  if channel_color EQ 'red' then begin
    tvscl, square_mask, 0, 0, 3
    tvscl, square_mask, 0, 0, 2
    endif
    
  if channel_color EQ 'green' then begin
    tvscl, square_mask, 0, 0, 3
    tvscl, square_mask, 0, 0, 1
    endif
endif

info.frameindex=frame
widget_control, event.top, SET_Uvalue=info, /no_copy
end

PRO decrementImage, event
widget_control, event.top, GET_Uvalue=info
frame=info.frameindex
file=info.picfilename
loc_file=info.locFilename

widget_control, info.drawID, get_value=win1
widget_control, info.referencechannelID, get_value=channel_color
if channel_color EQ 'red' then info.channel=1
if channel_color EQ 'green' then info.channel=2
wset, win1

if info.composite EQ 0 then begin
  frame=frame-1
  frame = (frame LT 0) ? 0 : frame
  pic=read_tiff(file, image_index=frame)
  ;blank=pic
  ;blank[*, *]=0
  erase
  ;tvscl, blank, 0, 0, 1
  contrast_index=where(pic GE info.peak_white)
  contrast_index=abs(contrast_index)
  pic(contrast_index) = info.peak_white
  tvscl, pic, 0,0, info.channel
  widget_control, info.outputlocalizeID, set_value='frame:'+string(frame+1)
  endif
  
if info.composite EQ 1 then begin
  frame=frame-2
  frame = (frame LT 0) ? 0 : frame
  pic_red=read_tiff(file, image_index=frame)
  pic_green=read_tiff(file, image_index=frame+1)
  ;blank=pic_red
  ;blank[*, *]=0
  erase
  ;tvscl, blank, 0, 0, 1
  contrast_index=where(pic_red GE info.peak_white)
  contrast_index=abs(contrast_index)
  pic_red(contrast_index) = info.peak_white
  tvscl, pic_red, 0,0, 1
  tvscl, pic_green, 0,0, 2
  widget_control, info.outputlocalizeID, set_value='frame:'+string((frame+2)/2)
  endif
  
 ;Now read the loc file
if loc_file NE 'temp' then begin
  loc=read_loc(loc_file)
  if (loc[0] LT 0) then begin
      res=dialog_message('Cannot read file.', title='Error in decrementImage')
      return
      endif
      
   if info.composite EQ 0 then begin 
    index=where(loc[3, *] EQ frame, count)
    int_loc=round(loc)
    widget_control, info.outputlocalizeID, set_value='spots:'+string(count), /append
    if index[0] LT 0 then begin
      int_loc[*]  = [0.0, 0.0, 0.0, frame]
      count = 1
    endif
    endif
    
    if info.composite EQ 1 then begin 
      index=where(loc[3, *] EQ frame/2, count)
      int_loc=round(loc)
      widget_control, info.outputlocalizeID, set_value='spots:'+string(count), /append
      if index[0] LT 0 then begin
        int_loc[*]  = [0.0, 0.0, 0.0, frame/2]
        count = 1
      endif
   endif 
  
  square_mask=bytarr(info.xtot, info.ytot)
  half_square=5
  for k = 0, count-1 do begin
    left_x=int_loc[0,index[k]]-half_square GT 0 ? int_loc[0,index[k]]-half_square : 0
    right_x=int_loc[0,index[k]]+half_square LT info.xtot-1 ? int_loc[0,index[k]]+half_square : info.xtot-1
    bottom_y=int_loc[1, index[k]]-half_Square GT 0 ? int_loc[1, index[k]]-half_Square : 0
    top_y= int_loc[1, index[k]]+half_square LT info.ytot-1 ? int_loc[1, index[k]]+half_square : info.ytot-1
    square_mask(left_x, bottom_y:top_y)=1
    square_mask(right_x, bottom_y:top_y)=1
    square_mask(left_x:right_x, top_y)=1
    square_mask(left_x:right_x, bottom_y)=1
    endfor
  s=replicate(1, 3, 3)
  if channel_color EQ 'red' then begin
    tvscl, square_mask, 0, 0, 3
    tvscl, square_mask, 0, 0, 2
    endif
    
  if channel_color EQ 'green' then begin
    tvscl, square_mask, 0, 0, 3
    tvscl, square_mask, 0, 0, 1
    endif
endif  
info.frameindex=frame
widget_control, event.top, SET_Uvalue=info, /no_copy
end