PRO gaussian_2d, independent, parameters, dependent, partials

; CURVE2DFIT takes an image an performs a non-linear least squares
; fit to a 2d-gaussian.  This program is based on the IDL
; CURVEIT algorithm.  The implementation is adapted from IDL
; technical support web page, ANALYSIS18.
;
; Dan Larson
; 6/12/00

; the 'independent vector is arranged with the psf width and the numbers
; of the "x" and "y" values in vector at the [0] ("psf_width"), [1] ("x" elements)
; and [1] ("y") elements.  The remaining part of the
; vector contains "x" then "y".
; independent = psf_width, nx, ny, x1, x2...., y1, y2, .....

psf_width=independent[0]    ; width of psf to be used in fitting function
nx = independent[1]  ; number of x elements
ny = independent[2]  ; number of y elements

; Forming "x" data and "y" data arrays.
; The (i, j) value of each array coincides with the
; (i, j) value of the "dependent" ("z" or the surface
; data) variable.  NOTE: matrix element referencing is
; row-major referencing, which is opposite the convention.
; For (i, j), the column is i, and the row is j.

xdata = replicate(1.0, ny) ## independent[3:nx+2]
ydata = independent[nx+3:*] ## replicate(1.0, nx)

; The result are two matrices which look like this:
; xdata = x1 x2 x3 x4   ydata = y1 y1 y1 y1
;       x1 x2 x3 x4       y2 y2 y2 y2
;       ..           ...

; calculating the surface data (dependent) from the
; xdata and ydata variables.
pi=3.1415926
dependent=(parameters[0]/(2.0*pi*psf_width^2))*exp(-((xdata-parameters[1])^2+(ydata-parameters[2])^2)/(2.0*psf_width^2))

; REFORMing the surface data (dependent) from the
; xdata and ydata variables.
dependent = reform(dependent, n_elements(dependent), /overwrite)

; This condition is used to speed up CURVEFIT.
; CURVEFIT sometimes calls this user defined
; procedure to obtain data points for bothe the
; function and it's derivatives; sometimes CURVEFIT
; just needs the data of the function.

if n_params() ge 4 then begin
    partials=dblarr((nx*ny), 3)
    partials[*, 0] = (1.0/(2.0*pi*psf_width^2))*exp(-((xdata-parameters[1])^2+(ydata-parameters[2])^2)/(2.0*psf_width^2))
;   partials[*, 3] = ((4.0/(psf_width^3))*((xdata-parameters[1])^2+(ydata-parameters[2])^2)-(2.0/psf_width))*$
;      expfunct
    partials[*, 1] = ((xdata-parameters[1])/(psf_width^2))*$
       (parameters[0]/(2.0*pi*psf_width^2))*exp(-((xdata-parameters[1])^2+(ydata-parameters[2])^2)/(2.0*psf_width^2))
    partials[*, 2] = ((ydata-parameters[2])/(psf_width^2))*$
       (parameters[0]/(2.0*pi*psf_width^2))*exp(-((xdata-parameters[1])^2+(ydata-parameters[2])^2)/(2.0*psf_width^2))

    endif

END

