FUNCTION gmask_fit, pic, parameters, xy_input=xy_input

; gmask_fit calculates the center of a psf using an iterative gaussian mask (Thompson et al.)
;
; Dan Larson
; 8/16/00

s=size(pic, /dimensions)
x_dim=s[0]
y_dim=s[1]
x0=0.0           ; center of mass coordinates
y0=0.0
F=1.0/(sqrt(2.0)*parameters.psfwidth)          ; This factor shows up repeatedly in GMASK
gauss_mask = dblarr(x_dim, y_dim)     ; gaussian mask for centroid fitting
error = 0.0                    ; rms distance between the 'true' spot and the centroid spot
results=dblarr(3)               ; this array hold the returned results of the function:
                           ; x0, y0, number of photons in spot
; offset correction
;This is a critical step in GMASK.  If the black level is determined automatically, or manually,
;then it is based on the ENTIRE image, and a single offset is used for the whole frame.
;If the offset correction is local, then a region surrounding the cut spot is used to find a best fit
;plane that is then subtracted from the image.

if parameters.auto_black_level_val LE 1 then blksubtract=(pic-parameters.blacklevel)
if parameters.auto_black_level_val EQ 2 then blksubtract=pic-local_background(pic)

image=(blksubtract GT 0)*blksubtract

; boundary condition.  border is set to zero
image[0, *]= 0.0
image[x_dim-1, *]= 0.0
image[*, 0]= 0.0
image[*, y_dim-1] = 0.0

; easy localisation by finding the centroid of the image

center=fast_centroid(image)
x0=center[0]
y0=center[1]

; iterative centroid calculation with gaussian mask
h = 1.0e-3       ; tolerance
diff_x=0.0
diff_y=0.0
repeat_index=0

x_dim = long(x_dim)
y_dim = long(y_dim)
array=lindgen(x_dim, y_dim)
xarr=array mod x_dim
yarr=array/x_dim

;***********************buffer************************
;This addition takes an INPUT value of (x,y) and calculates the photon number directly,without going
;through the fitting routine
if keyword_set(xy_input) then begin
	x0=xy_input[0]
	y0=xy_input[1]
	a=F*(yarr - 0.5 - y0)
    b=F*(yarr + 0.5 - y0)
    c=F*(xarr - 0.5 - x0)
    d=F*(xarr + 0.5 - x0)
    gauss_mask =0.25*(errorf(a)-errorf(b))*(errorf(c)-errorf(d))
    endif else begin
	;**********************************************************
	;This is the NORMAL operation of GMASK (i.e  without the xy-input switch
		REPEAT begin
			x0=x0 + diff_x/2.0
			y0=y0 + diff_y/2.0
			;print, x0, y0
			a=F*(yarr - 0.5 - y0)
			b=F*(yarr + 0.5 - y0)
			c=F*(xarr - 0.5 - x0)
			d=F*(xarr + 0.5 - x0)
			gauss_mask =0.25*(errorf(a)-errorf(b))*(errorf(c)-errorf(d))
			sum=total(image*gauss_mask)
			trial_x0=total(xarr*image*gauss_mask)
			trial_y0=total(yarr*image*gauss_mask)
			;print, x0, trial_x0, sum, trial_x0/sum
			diff_x = trial_x0/sum - x0
			diff_y = trial_y0/sum - y0
			repeat_index=repeat_index+1
			endrep until (abs(diff_x) LT h) and (abs(diff_y) LT h) or (repeat_index GT 300)

			if (repeat_index GT 300) then begin
			    ;print, "GMASK ITERATION MAXED OUT (number of iterations=", repeat_index, ")"
			    results[2]=0.0
			    return, results
			    endif
		endelse

; photon number calc
sum = total(gauss_mask*gauss_mask)
N = total(image*gauss_mask)
photon_number = N/sum;
results[0]=x0
results[1]=y0
results[2]=photon_number
return, results
end