function leastsqr_fit, pic, trackparameters

; spot is the image to be fit. psf_width is the width of the psf (sigma) divided by the pixel value.
; i.e., in the theory, psf_width = s/a.  bn_width is the width of the gaussian distributed background
; noise

bn_width = 1.0
pi=3.1415926
psf_width=trackparameters.psfwidth
s=size(pic, /dimensions)
nx = s[0]
ny = s[1]
x= dindgen(nx)
y = dindgen(ny)
max_loc = 0.0    ; variable for maximum routine
amplitude = 0.0     ; value of maximum
results=dblarr(3)   ; holds the results returned from this function
ls_mask=dblarr(nx, ny)

; offset correction
image=pic-trackparameters.blacklevel

; boundary condition.  border is set to zero
image[0, *]= 0.0
image[nx-1, *]= 0.0
image[*, 0]= 0.0
image[*, ny-1] = 0.0

; easy, easy localisation by finding the maximum of the image
amp = max(image, max_loc)

; creating initial guess of parameters.  The amplitude and
; center are found by taking the height and position of the
; maximum, respectively

parameters = [amp*2.0*pi*psf_width^2, max_loc mod nx, max_loc/nx]
; print, "initial guess:", parameters

;calling CURVEFIT.  The weighting is the critical part of the model.  Change 'z' to 'image'
; print, nx, ny
; print, size(image, /dimensions)
image=reform(image, nx*ny, /overwrite)
weights = 1.0/(abs(image) + bn_width^2)     ; the weights are composed of 1) uniformly distributed background noise and 2) shot noise
iteration = 0
zfit=mpcurvefit([psf_width, nx, ny, x, y], image, weights, parameters, function_name = 'gaussian_2d', itmax=300, tol=1.0e-5, iter=iteration, /quiet)
;note: MPCURVEFIT is the Levengerg-Marquadt least squares algorithm from Craig B. Markwardt.
;it directly replaces the IDL version and is MUCH MUCH BETTER.
if (iteration GE 300) then begin
    ;print, "CURVE2DFIT ITERATION MAXED OUT (number of iterations=", iteration, ")"
    results[2]=0.0
    return, results
    endif

;if (iteration LT 300) then print, "leastsqr_fit convergence satisfied (number of iterations=", iteration, ")"


; calculating and outputting error and the resulting parameters

; REFORMing resulting curve fit into a two-dimensional array and displaying it
zfit= reform(zfit, nx, ny, /overwrite)

; calculation of photon number.  Instead of using N, use the weighted
; gaussian mask technique used in gmask_fit

N=0.0
sum = 0.0
image=reform(image, nx, ny, /overwrite)
array=lindgen(nx, ny)
xarr=array mod nx
yarr=array/nx
F=1.0/(sqrt(2.0)*psf_width)
a=F*(yarr - 0.5 - parameters[2])
b=F*(yarr + 0.5 - parameters[2])
c=F*(xarr - 0.5 - parameters[1])
d=F*(xarr + 0.5 - parameters[1])
ls_mask =0.25*(errorf(a)-errorf(b))*(errorf(c)-errorf(d))
sum = total(ls_mask*ls_mask)
N = total(image*ls_mask)
photon_number = N/sum

results[0]=parameters[1]
results[1]=parameters[2]
results[2]=photon_number
return, results
end