FUNCTION local_background, pic, DISPLAY=display

;get the dimensions of the input and extract border coordinates
pic_dim=size(pic, /dimensions)
x_dim=pic_dim[0]
y_dim=pic_dim[1]

x_border=dblarr(2*x_dim)
y_border=dblarr(2*y_dim)

x_border[0:x_dim-1] = pic[*, 0]
x_border[x_dim:2*x_dim-1]=pic[*, y_dim-1]

x=dblarr(2*x_dim)
x[0:x_dim-1]=dindgen(x_dim)
x[x_dim:2*x_dim-1]=dindgen(x_dim)

y_border[0:y_dim-1] = pic[0, *]
y_border[y_dim:2*y_dim-1]=pic[x_dim-1, *]

y=dblarr(2*y_dim)
y[0:y_dim-1]=dindgen(y_dim)
y[y_dim:2*y_dim-1]=dindgen(y_dim)

;following the method of Bevington, p. 96
delta_x=2*x_dim*total(x^2)-(total(x))^2
a=(1./delta_x)*(total(x^2)*total(x_border)-total(x)*total(x*x_border))
b=(1./delta_x)*(2*x_dim*total(x*x_border)-total(x)*total(x_border))

delta_y=2*y_dim*total(y^2)-(total(y))^2
c=(1./delta_y)*(total(y^2)*total(y_border)-total(y)*total(y*y_border))
d=(1./delta_y)*(2*y_dim*total(y*y_border)-total(y)*total(y_border))

;The offset which is returned is averaged over each edge in x, and each edge in y.
;The actual offset needs to be corrected for the tilt of the plane.
;Then, the 2 offsets are averaged together to give a single offset.
offset=(a- d*(y_dim-1)/2.0+c - b*(x_dim-1)/2.0 )/2.0

if keyword_set(display) then begin
	print, 'slope:', b, d
	print, 'offset:', offset
	print, 'adjusted: ', a-d*(y_dim-1)/2.0, c-b*(x_dim-1)/2.0
	!p.multi=[0,1,2]
	plot, x, x_border, psym=4
	oplot, x, a+b*x
	plot, y, y_border, psym=6
	oplot, y, c+d*y
	!p.multi=[0,1,1]
	endif

; now define the background plane in terms of the fit parameters
plane=dblarr(x_dim, y_dim)
For i=0, x_dim-1 do begin
	For j=0, y_dim-1 do begin
		plane[i, j]=offset+b*double(i)+d*double(j)
	endfor
endfor

return, plane
end
