;********************localizeApp.pro***********************************
;Version history:
;v 1.0 localize routines only
;v 2.0 addition of track routines.  output messaging is not great, meaning that it is
;prone to crashing when errors are found
;v 2.1 added IPL->pic converter
;v 2.3 ipl->pic converter modified to use 16 bit images
;v 4.0 added region of interest code

PRO abortButton, event
WIDGET_CONTROL, /RESET
CLOSE, /FORCE, /ALL
HEAP_GC
return
end

PRO myApp_quit, event
widget_control, event.top, /destroy
end

PRO myApp_locopen, event
file = DIALOG_PICKFILE(/READ, FILTER = '*.loc', dialog_parent=event.top, get_path=dir)
cd, dir
if file eq '' then return

widget_control, event.top, GET_Uvalue=info
info.locFilename=file
widget_control,info.outputlocalizeID, set_value='opening file:'+file,/append
widget_control, info.referencechannelID, get_value=channel_color
if channel_color EQ 'red' then info.channel=0
if channel_color EQ 'green' then info.channel=1

loc=read_loc(file)
if (loc[0] LT 0) then begin
    res=dialog_message('Cannot read file.', title='Error in myApp_locopen')
    return
    endif
frame=info.frameindex
index=where(loc[3, *] EQ frame/(info.composite+1), count)
int_loc=round(loc)

if index[0] LT 0 then begin
    res=dialog_message('Frame number does not match image number.'+string(10B)+$
    'Try setting frame='+string(loc[3, 0]+1), title='Error in myApp_locopen')
    return
    endif

widget_control, info.drawID, get_value=win1
wset, win1

square_mask=bytarr(info.xtot, info.ytot)
half_square=5
for k = 0, count-1 do begin
  left_x=int_loc[0,index[k]]-half_square GT 0 ? int_loc[0,index[k]]-half_square : 0
  right_x=int_loc[0,index[k]]+half_square LT info.xtot-1 ? int_loc[0,index[k]]+half_square : info.xtot-1
  bottom_y=int_loc[1, index[k]]-half_Square GT 0 ? int_loc[1, index[k]]-half_Square : 0
  top_y= int_loc[1, index[k]]+half_square LT info.ytot-1 ? int_loc[1, index[k]]+half_square : info.ytot-1
  square_mask(left_x, bottom_y:top_y)=1
  square_mask(right_x, bottom_y:top_y)=1
  square_mask(left_x:right_x, top_y)=1
  square_mask(left_x:right_x, bottom_y)=1
  endfor
s=replicate(1, 3, 3)
if channel_color EQ 'red' then begin
  tvscl, square_mask, 0, 0, 3
  ;tvscl, square_mask, 0, 0, 2
  endif
  
if channel_color EQ 'green' then begin
  tvscl, square_mask, 0, 0, 3
  ;tvscl, square_mask, 0, 0, 1
  endif

;mask=bytarr(info.xtot, info.ytot)
;mask[*, *]=0
;mask[transpose(round(loc[0, index])), transpose(round(loc[1, index]))]=1
;
;tvscl, dilate(mask, s), 0, 0, 1

widget_control, event.top, SET_Uvalue=info, /no_copy
return
end

PRO myApp_composite_open, event
file = DIALOG_PICKFILE(/READ, FILTER = '*.tif', dialog_parent=event.top, get_path=dir)
cd, dir
if file eq '' then return

widget_control, event.top, GET_Uvalue=info
info.picFilename=file
info.frameindex=0     ;ALWAYS zero the frame index when opening a new file
widget_control, info.drawID, get_value=win1
wset, win1
res = QUERY_TIFF(file, IMAGE_INDEX=0, image_info)

IF ((res EQ 0) OR (strpos(image_info.description, 'composite') EQ -1)) then begin
       res=dialog_message('Cannot read composite tif file', title='File error in myApp_composite_open')
       return
     endif

IF  strmid(image_info.description, strpos(image_info.description, 'channels=')+9, 1) NE '2' then begin
        res=dialog_message('The composite image must be a two channel image', title='File error in myApp_composite_open')
        return
        endif
        
pic_red=read_tiff(file, image_index=0)
pic_green=read_tiff(file, image_index=1)
erase
tvscl, pic_green, 0,0, 2
tvscl, pic_red, 0, 0, 1
widget_control, info.outputlocalizeID, set_value='frame:'+string(1),/append
info.composite=1  ;set the switch to make sure all subsequent processing is in composite images
info.num_images=image_info.num_images
widget_control, event.top, SET_Uvalue=info, /no_copy
end

PRO myApp_open, event
file = DIALOG_PICKFILE(/READ, FILTER = '*.tif', dialog_parent=event.top, get_path=dir)
cd, dir
if file eq '' then return

widget_control, event.top, GET_Uvalue=info
info.picFilename=file
info.frameindex=0     ;ALWAYS zero the frame index when opening a new file
widget_control, info.drawID, get_value=win1
wset, win1
res = QUERY_TIFF(file, IMAGE_INDEX=0, image_info)
IF (res EQ 0) then begin
       res=dialog_message('Cannot read tif file', title='File error in myApp_open')
       return
     endif
pic=read_tiff(file, image_index=0)
erase
tvscl, pic, 0,0, 2
widget_control, info.outputlocalizeID, set_value='frame:'+string(1),/append
info.composite=0  ;set the switch to make sure all subsequent processing is on single-channel images
info.num_images=image_info.num_images
widget_control, event.top, SET_Uvalue=info, /no_copy
end

PRO localizeApp_event, event
widget_control, event.top, GET_Uvalue=info
widget_control, info.drawID, get_value=win1
wset, win1
dummy=bytarr(info.xtot,info.ytot)
x0=info.selection_par[3]
y0=info.selection_par[4]
x1=info.selection_par[5]
y1=info.selection_par[6]
;event.type = 0 --> push
;event.type = 1 --> release
;event.type = 2 --> drag
widget_control, info.xpositionID, set_value=string(event.x)
widget_control, info.ypositionID, set_value=string(event.y)
;print, event.x, event.y

if event.release EQ 4 then begin
    ;print, 'right button'
    pos=compare_click_to_file(info.locFilename, info.frameindex, event.x, event.y, info.composite)
    if pos[0] eq -1 then return
    widget_control, info.iniposxID, set_value=pos[0]
    widget_control, info.iniposyID, set_value=pos[1]
    widget_control, info.NvalueID, set_value=string(pos[2])
    widget_control, info.xpositionID, set_value=string(pos[0])
    widget_control, info.ypositionID, set_value=string(pos[1])
    endif

if (event.type EQ 0 and event.press EQ 1) then begin
    info.selection_par[0]=0
    x0= event.X
    y0= event.Y
    ;print, "start:", x0, y0
    endif
if (event.type EQ 2) and (info.selection_par[0] EQ 0) then begin
    x1=event.x
    y1=event.y
    x1=((x1 GT 0) and (x1 LT info.xtot-1))*x1   ;needed to make sure the ROI is within the boundaries
    y1=((y1 GT 0) and (y1 LT info.ytot-1))*y1
    highX= (x0 GT x1) ? x0 : x1   ;IF (A GT B) THEN Z = A ELSE Z = B
    lowX= (x0 LT x1) ? x0 : x1
    highY= (y0 GT y1) ? y0 : y1
    lowY= (y0 LT y1) ? y0 : y1
    dummy[lowX, lowY:highY]=1
    dummy[lowX:highX, highY]=1
    dummy[highX, lowY:highY]=1
    dummy[lowX:highX,lowY]=1
    ;print, "middle:", x1, y1
    s=replicate(1, 3, 3)
    tvscl, dilate(dummy, s), 0, 0, 3
    endif

info.selection_par[3:6]=[x0, y0, x1, y1]

if event.type EQ 1 then begin
    x1=event.x
    y1=event.y
    ;print, "end:", x1, y1
    highX= (x0 GT x1) ? x0 : x1   ;IF (A GT B) THEN Z = A ELSE Z = B
    lowX= (x0 LT x1) ? x0 : x1
    highY= (y0 GT y1) ? y0 : y1
    lowY= (y0 LT y1) ? y0 : y1
    info.selection_par[0]=-1
    info.selection_par[3:6]=[lowX, lowY, highX, highY]
    endif

widget_control, event.top, SET_Uvalue=info, /no_copy

end

PRO about_dialog, event
text='v 16.0'+string(10B)+'Daniel Larson'+string(10B)+'dan.larson@nih.gov'+string(10B)+'released 9/27/13'
res=dialog_message(text, /information, title='About Localize')
end

pro localizeApp
xs= 650 ; 1024 ;;size of visible window
ys=650 ;1024 ;
xtot=2048   ;maximum size of image
ytot=2048
;top level base

tlb = widget_base(Title='Localize', /row, MBar=menubarID)

; make a left base:
leftBase = widget_base(tlb, /col)

; make a right base:
drawBase = widget_base(tlb, /col)

;Create the menubar
fileID=widget_button(menubarID, value='File', /menu)
viewID=widget_button(menubarID, value='View', /menu)
convertID=widget_button(menubarID, value='Convert', /menu)
calculateID=widget_button(menubarID, value='Calculate', /menu)
;roiID=widget_button(menubarID, value='ROI', /menu)
localizemenuID=widget_button(menubarID, value='Localize', /menu)
trackID=widget_button(menubarID, value='Track', /menu)
trackbuttonID=widget_button(trackID, value='Track', Event_pro='trackButton')
trackmanualbuttonID=widget_button(trackID, value='Track Manual', Event_pro='trackManualButton')
DualtrackButtonID=widget_button(trackID, value='Dual color track', Event_pro='DualtrackButton')
multichannelmaskID=widget_button(menubarID, value='Multichannel Mask', /menu)
helpID=widget_button(menubarID, value='Help', /menu)
tif_picID=widget_button(convertID, value='tif -> pic...', Event_pro='tif_pic')
ipl_picID=widget_button(convertID, value='ipl -> pic..', Event_pro='ipl_pic_open')
tif_iplID=widget_button(convertID, value='tif -> ipl..', Event_pro='tif_ipl')
lsm_iplID=widget_button(convertID, value='lsm -> ipl..', Event_pro='lsm_ipl')
statsID=widget_button(calculateID, value='statistics...', Event_pro='statistics')
gaussfitID=widget_button(calculateID, value='radius of spot...', Event_pro='smallWindowGaussianFit')
;selectmenuID=widget_button(menubarID, value='Select', /menu)
;selectregionID=widget_button(selectmenuID, value='Select region', Event_pro='select_region')
quitID=widget_button(fileID,value='Quit', Event_pro='myApp_quit')
createmultichannelmaskID=widget_button(multichannelmaskID, value='Create....', event_pro='createMultiChannelMask', sensitive=0)
openID=widget_button(fileID,value='Open tif (1 channel)...', Event_pro='myApp_open')
open_compositeID=widget_button(fileID, value='Open composite tif (2 channel)...', Event_pro='myApp_composite_open')
openlocID=widget_button(fileID,value='Open loc file ...', Event_pro='myApp_locopen')
openBatchID=widget_button(fileID, value='Setup batch file...', Event_pro='batch_setup')
bpassviewID=widget_button(viewID,value='View bpass image...', Event_pro='bpassView')
rawviewID=widget_button(viewID, value='View raw image...', Event_pro='rawView')
bpassview_stackID=widget_button(viewID,value='View bpass stack...', Event_pro='bpassViewStack')
aboutID=widget_button(helpID, value='About', Event_pro='about_dialog')

;create the action buttons
localizeID=widget_button(localizemenuID, value='localize', Event_pro='localizeButton')
localizefixedmaskID=widget_button(localizemenuID, value='localize with a fixed mask', Event_pro='localizefixedmaskButton', sensitive=0)
localizeroiID=widget_button(localizemenuID, value='localize with a single ROI', Event_pro='localizeroiButton', sensitive=1)
localizeroimanyID=widget_button(localizemenuID, value='localize with a ROI in each frame', Event_pro='localizemanyroiButton', sensitive=1)
localizeauxiliaryID=widget_button(localizemenuID, value='localize with an auxiliary LOC or TRK file', Event_pro='localizeauxButton', sensitive=1)
localizeBootStrapID=widget_button(localizemenuID, value='localize in bootstrap mode', Event_pro='localizeBootStrapButton', sensitive=1)
localizeReverseID=widget_button(localizemenuID, value='localize in reverse mode', Event_pro='localizeReverseButton', sensitive=1)
localizeDualID=widget_button(localizemenuID, value='localize in dual color mode', Event_pro='localizeDualButton', sensitive=1)
localizeParameterMenuID=widget_button(localizemenuID, value='localization parameters...', Event_pro='localizeParameterMenu', sensitive=0)
;abortID=widget_button(parameterBase, value='abort', event_pro='abortButton')

;create the left parameter fields

parameterBase=widget_base(leftBase, /frame, /col, /scroll)
referencechannelID=cw_field(parameterBase, title='reference channel', value='green')      ;this threshold applies AFTER the bpass filtering
bpassthresholdID=cw_field(parameterBase, title='band pass threshold', value=400, /floating)      ;this threshold applies AFTER the bpass filtering
photonthresholdID=cw_field(parameterBase, title='photon threshold', value= 10.0, /floating)     ; any spots with fewer photons will be discarded
autoBpassbase=widget_base(parameterbase, /row)
autotextID=widget_label(autoBpassbase, value='auto bpass')
autoBpassID=cw_bgroup(autoBpassbase, ['on (default)', 'off'], column=2, /exclusive, event_func='auto_bpass', /no_release)
autoBpassthresholdID=cw_field(autoBpassbase, title='', value=7.0, /floating, xsize=8)
blacklevelBase=widget_base(parameterbase, /row)
blackleveltextID=widget_label(blacklevelBase, value='black level: ')
blacklevelSelectID=cw_bgroup(blacklevelBase, ['auto', 'manual', 'local (default)'], column=3, /exclusive, event_func='auto_black_level', /no_release)
blacklevelID=cw_field(parameterBase, title='manual black level: ', value=10.0, /floating, xsize=8)

first_last_base=widget_base(parameterbase, /row)
firstID=cw_field(first_last_base, title='frames: ', value=1u, /long, xsize=6)
lastID=cw_field(first_last_base, title='', value=1u, /long, xsize=6)

x_offspotID=cw_field(parameterBase, title='x shift', value=0.0, /floating)  ;values to do a fixed mask localization at some arbitrary point
y_offspotID=cw_field(parameterBase, title='y shift', value=0.0, /floating) ;only used in LOCALIZEFIXEDMASKBUTTON

psfwidthID=cw_field(parameterBase, title='radius of spot', value=1.7, /floating) ; width of point spread function in pixel units
cutsizeID=cw_field(parameterBase, title='cut size', value=3.5, /floating)       ; cut size determines the size of the selected spot.
toleranceID=cw_field(parameterBase, title='tolerance', value=2.0, /floating)          ; any spots closer than the tolerance will be considered the same
                           ; spot in 'cull_spot'
algorithmID=cw_bgroup(parameterBase, ['gaussian mask (default)', 'nonlinear least squares'], /exclusive, event_func='algorithm_select', /no_release)
FCS_FRAP_Base=widget_base(parameterBase, /row)
FCS_FRAP_labelID=widget_label(FCS_FRAP_Base, value='Spot finding for FRAP / FCS:')
FCS_FRAP_ID=cw_bgroup(FCS_FRAP_Base, ['on', 'off (default)'], column=2, /exclusive, event_func='FCS_FRAP_loc', /no_release)

confirmID=widget_button(drawBase, value='confirm ROI', event_pro='confirmROI')

rtfmBase=widget_base(leftBase, /row)
rtfmlabelID=widget_label(rtfmBase, value='RTFM filter:')
rtfmID=cw_bgroup(rtfmBase, ['on', 'off (default)'], column=2, /exclusive, event_func='rtfm_select', /no_release)

displayBase=widget_base(leftBase, /frame, /col)
;forwardbackwardBase
forwardbackwardBase=widget_base(displayBase, /row)
backwardID=widget_button(forwardbackwardBase, value='<--', event_pro='decrementImage')
forwardID=widget_button(forwardbackwardBase, value='-->', event_pro='incrementImage')
text1ID=widget_label(forwardbackwardBase, value='set frame:', /align_right)
absoluteposID=widget_text(forwardbackwardBase, value='1', event_pro='absFrame', /editable)

positionBase=widget_base(displayBase, /row)
xpositionID=widget_text(positionBase, xsize=12)
ypositionID=widget_text(positionBase, xsize=12)
NvalueID=widget_text(positionBase, xsize=12)

;contrast slider
peak_white= 65536 ;4095 ;4095 is the max value for 12 bit images
contrast_slider=widget_slider(displayBase, title='green channel contrast', event_pro='contrast_adjustment', $
    value=peak_white, maximum=peak_white)

;create localize output label
outputBase=widget_base(leftBase, /row)
outputlocalizeID=widget_text(outputBase, value='output window', /align_left, ysize=6, /scroll,  xsize=45)  ;only 6 lines for laptop

;create the track parameter fields
trackBase=widget_base(leftBase, /frame, /col, /scroll)
maxdispID=cw_field(trackBase, title='maximum displacement', value=12.0, /floating) ; max disp
initposBase=widget_base(trackBase, /row)
iniposxID=cw_field(initposBase, title='initial position:', value=0, /floating, xsize=6) ; inipos
iniposyID=cw_field(initposBase, title='', value=0, /floating, xsize=6)
track_memoryID=cw_field(trackBase, title='track_memory', value = 1, /integer) ; track_memory
goodenoughID=cw_field(trackBase, title='good enough', value=10, /integer);
dimID=cw_field(trackBase, title='dimensionality', value=2, /integer, /noedit) ;

;verbose=verbose,quiet=quiet

;create the only draw window
drawID = widget_draw(drawBase, /frame, /scroll, x_scroll=xs, y_scroll=ys, xsize=xtot, ysize=ytot, $
/button_events, /motion_events)

height = max(widget_height(drawBase))
widget_control, parameterBase, ysize=0.325*height ;0.325*height ;
widget_control, displayBase, ysize=0.140*height; 0.140*height ;  
widget_control, trackBase, ysize=0.140*height
widget_control, drawBase, ysize=0.75*height;0.75*height; 

; Realize the widgets.
WIDGET_CONTROL, tlb, /REALIZE

;create the global structure
;Primary parameters.  These are the parameters that are most often adjusted.
; psfwidth: width of point spread function in pixel units
; cutsize: determines the size of the selected spot.
; bpassthreshold: this threshold applies AFTER the bpass filtering
; photonthreshold: any spots with fewer photons will be discarded
; tolerance: any spots closer than the tolerance will be considered the same spot in 'cull_spot'

selection_par=[-1, -1, -1, 0, 0, 0, 0] ;push_down, release, motion, x0, y0, x1, y1

info={$
    picFilename:'temp', $
    locFilename:'temp', $
    drawID:drawID,  $
    firstID:firstID,     $
    lastID:lastID,          $
    selection_par:selection_par,    $
    psfwidthID:psfwidthID, $
    blacklevelID:blacklevelID, $
    cutsizeID:cutsizeID, $
    referencechannelID:referencechannelID, $
    bpassthresholdID:bpassthresholdID, $
    autoBpassthresholdID:autoBpassthresholdID, $
    blacklevelSelectID:blacklevelSelectID, $
    photonthresholdID:photonthresholdID, $
    toleranceID:toleranceID,$
    confirmID:confirmID, $
    outputlocalizeID:outputlocalizeID, $
    maxdispID:maxdispID, $
    iniposxID:iniposxID, $
    iniposyID:iniposyID, $
    track_memoryID:track_memoryID, $
    dimID:dimID, $
    goodenoughID:goodenoughID, $
    channel:0, $    ;default value is always channel 0 unless otherwise specified
    algorithm:0,$   ;algorithm select (Gaussian Mask or Nonlinear Least Squares)
    FCS_FRAP:1, $   ;localization for FCS or FRAP (default = 1 = off)
    rtfm_filter:1, $
    auto_bpass_val:0, $        ;default value = on
    auto_black_level_val:2, $   ;default value = local background subtraction
    xtot:xtot, $
    ytot:ytot, $
    x_offspotID:x_offspotID, $
    y_offspotID:y_offspotID, $
    xpositionID:xpositionID, $
    ypositionID:ypositionID, $
    NvalueID:NvalueID, $
    frameindex:0, $
    composite:0, $            ;boolean for composite image. default = 0 (no)
    roimanyIndex:1, $
    num_images:1, $
    peak_white:peak_white, $
    assignmultichannelmask:0, $  ;0 = default value=no multichannel mask; 1= use multichannel mask
    spot_number:0$
    }

widget_control, tlb, Set_Uvalue=info, /no_copy
widget_control, confirmID, sensitive=0

; Call XMANAGER to manage the event loop.
XMANAGER, 'localizeApp', tlb, /NO_BLOCK

return
end