PRO localizeauxButton, event

;get the global strucutre
widget_control, event.top, GET_Uvalue=info
widget_control, info.firstID, get_value=first
widget_control, info.lastID, get_value=last
widget_control, info.psfwidthID, get_value=psfwidth
widget_control, info.cutsizeID, get_value=cutsize
widget_control, info.bpassthresholdID, get_value=bpassthreshold
widget_control, info.autoBpassthresholdID, get_value=autoBpassThreshold
widget_control, info.toleranceID, get_value=tolerance
widget_control, info.blacklevelID, get_value=blacklevel
widget_control, info.outputlocalizeID, set_value=' '
widget_control, info.maxdispID, get_value=maxdisp   ;This line is added for the FCS_FRAP spot finding module

;Need to set the photon threshold to 0.0 so ALL spots are returned from the auxiliary localize operation.
widget_control, info.photonthresholdID, set_value=0.0

;check for the RTFM filter selection

;print, info.rtfm_filter

if (info.fcs_frap EQ 0) OR (info.algorithm EQ 1) then begin
	res=dialog_message(title='Error in localizeAuxButton', 'Auxiliary localization is compatitble neither with FCS/FRAP mode'$
	+String(10B)+'nor with Nonlinear Least Squares Fitting', dialog_parent=event.top)
	return
	endif

if info.rtfm_filter EQ 0 then begin
    ;usage: PRO rtfm, filename, highFTarget, sliceArr, t_slice
    rtfm, info.picFilename, res, outputID=info.outputlocalizeID
    a=where(res EQ 1)
    first=a[0]+1    ;the +1 is necessary to convert from the RTFM return value to our frame values
    last=a[0]+1
    endif

auxfile=dialog_pickfile(/read, dialog_parent=event.top, title='Choose a LOC/TRK file for the position information', filter=['*.loc', '*.trk'])

if strupcase(STRMID(auxfile, 2, /REVERSE_OFFSET)) EQ 'LOC' then aux_dat=read_loc(auxfile)
if strupcase(STRMID(auxfile, 2, /REVERSE_OFFSET)) EQ 'TRK' then aux_dat=read_loc(auxfile)

;Do we need this error message??
;if (aux_dat[0] LE 0) then begin
;    res=dialog_message('File read error, localizeauxbutton quitting', title='Error in localizeauxButton',  dialog_parent=event.top)
;    return
;    endif

locparameters={$
    filename:info.picFilename, $
    blacklevelID:info.blacklevelID, $
    first:first, $
    last:last, $
    psfwidth:psfwidth, $
    cutsize:cutsize, $
    bpassthreshold:bpassthreshold, $
    auto_bpass_val:info.auto_bpass_val, $
    auto_black_level_val:info.auto_black_level_val, $
    autoBpassThreshold:autoBpassThreshold, $
    photonthreshold:0.0, $  ;the photon threshold is set to 0 so that all spots are returned.
    tolerance:tolerance, $
    blacklevel:blacklevel, $
    outputlocalizeID:info.outputlocalizeID, $
    peak_white:info.peak_white, $
    algorithm:info.algorithm, $
    FCS_FRAP:info.FCS_FRAP, $
    composite:info.composite, $
    channel:info.channel, $
    num_images:info.num_images, $
    auxfile:auxfile, $
    maxdisp:maxdisp $
         }

;call localize.pro
localize, locparameters, /auxiliary

return
end
