PRO localizeDualButton, event

;get the global strucutre
widget_control, event.top, GET_Uvalue=info

widget_control, info.firstID, get_value=first
widget_control, info.lastID, get_value=last
widget_control, info.psfwidthID, get_value=psfwidth
widget_control, info.cutsizeID, get_value=cutsize
widget_control, info.bpassthresholdID, get_value=bpassthreshold
widget_control, info.autoBpassthresholdID, get_value=autoBpassThreshold
widget_control, info.photonthresholdID, get_value=photonthreshold
widget_control, info.toleranceID, get_value=tolerance
widget_control, info.blacklevelID, get_value=blacklevel
widget_control, info.outputlocalizeID, set_value=' '

widget_control, info.maxdispID, get_value=maxdisp   ;This line is added for the FCS_FRAP spot finding module
widget_control, info.referencechannelID, get_value=channel_color
if channel_color EQ 'red' then info.channel=0
if channel_color EQ 'green' then info.channel=1

if info.rtfm_filter EQ 0 then begin
    ;usage: PRO rtfm, filename, highFTarget, sliceArr, t_slice
    rtfm, info.picFilename, res, outputID=info.outputlocalizeID
    a=where(res EQ 1)
    first=a[0]
    last=a[0]
    endif
info.composite = 0    ;this line is critical. Now, localize will run on every frame
locparameters={$
    filename:info.picFilename, $
    first:first, $
    last:last, $
    psfwidth:psfwidth, $
    cutsize:cutsize, $
    bpassthreshold:bpassthreshold, $
    autoBpassThreshold:autoBpassThreshold, $
    auto_bpass_val:info.auto_bpass_val, $
    auto_black_level_val:info.auto_black_level_val, $
    photonthreshold:photonthreshold, $
    tolerance:tolerance, $
    blacklevel:blacklevel, $
    outputlocalizeID:info.outputlocalizeID, $
    blacklevelID:info.blacklevelID, $
    peak_white:info.peak_white, $
    FCS_FRAP:0, $       ;must run bootstrap in FCS FRAP mode
    algorithm:info.algorithm, $
    composite:info.composite, $
    channel:info.channel, $
    num_images:info.num_images, $
    maxdisp:maxdisp $
     }

;take the selection parameters and put them in the form for localize
region=intarr(4)
region[0]=info.selection_par[3]
region[1]=info.selection_par[4]
region[2]=info.selection_par[5]-info.selection_par[3]
region[3]=info.selection_par[6]-info.selection_par[4]

;erase the previous values and reset the ROI
info.selection_par=[-1, -1, -1, 0, 0, 0, 0]
widget_control, event.top, SET_uvalue=info, /no_copy
;note: if you want the ROI to be kept from run, to run, just remove the above line

;call localize.pro
localize, locparameters, selection=region, /bootstrap
return
end
