PRO localizefixedmaskButton, event

;get the global strucutre
widget_control, event.top, GET_Uvalue=info

widget_control, info.firstID, get_value=first
widget_control, info.lastID, get_value=last
widget_control, info.psfwidthID, get_value=psfwidth
widget_control, info.cutsizeID, get_value=cutsize
widget_control, info.bpassthresholdID, get_value=bpassthreshold
widget_control, info.autoBpassthresholdID, get_value=autoBpassThreshold
widget_control, info.photonthresholdID, get_value=photonthreshold
widget_control, info.toleranceID, get_value=tolerance
widget_control, info.blacklevelID, get_value=blacklevel
widget_control, info.outputlocalizeID, set_value=' '
widget_control, info.drawID, get_value=drawID
widget_control, info.x_offspotID, get_value=x_offspot
widget_control, info.y_offspotID, get_value=y_offspot

widget_control, info.maxdispID, get_value=maxdisp   ;This line is added for the FCS_FRAP spot finding module


locparameters={$
    filename:info.picFilename, $
    first:1, $   ;first and last are 1, because there is only one image in the average pic
    last:1, $
    psfwidth:psfwidth, $
    cutsize:cutsize, $
    bpassthreshold:bpassthreshold, $
    auto_bpass_val:info.auto_bpass_val, $
    auto_black_level_val:info.auto_black_level_val, $
    autoBpassThreshold:autoBpassThreshold, $
    photonthreshold:photonthreshold, $
    tolerance:tolerance, $
    blacklevel:blacklevel, $
    outputlocalizeID:info.outputlocalizeID, $
    blacklevelID:info.blacklevelID, $
    peak_white:info.peak_white, $
    FCS_FRAP:info.FCS_FRAP, $
    algorithm:info.algorithm, $
    maxdisp:maxdisp $
     }

;read the first pic to get the dimensions

pic=read_tiff(info.picFilename, image_index=first-1)
pic_size=size(pic, /dimensions)
sum_pic=dblarr(pic_size[0], pic_size[1])

;read each frame and generate an averaged pic of the whole series

widget_control, info.outputlocalizeID, set_value='AVERAGING...'
for i=first-1, last-1 do begin
    pic=read_tiff(info.picFilename, image_index= i)
    sum_pic=sum_pic+double(pic)
;    widget_control, info.outputlocalizeID, set_value='frame:'+string(i)+ '...',$
;     /append, SET_TEXT_TOP_LINE=(i-1) > 0
    endfor
    ave_pic=sum_pic/double(last-first+1)
    wset, drawID
    tvscl, ave_pic
    widget_control, info.outputlocalizeID, set_value='finished', /append
    widget_control, info.outputlocalizeID, set_value='median'+string(median(ave_pic)), /append

;take the selection parameters and put them in the form for localize
region=intarr(4)
region[0]=info.selection_par[3]
region[1]=info.selection_par[4]
region[2]=info.selection_par[5]-info.selection_par[3]
region[3]=info.selection_par[6]-info.selection_par[4]

localize, locparameters, fixed_mask_image=ave_pic, selection=region

;now read the file that was generated
loc_filename=change_extension(info.picFilename, 'loc')
fixed_mask_loc=read_loc(loc_filename)
if (fixed_mask_loc[0] LE 0) then begin
    res=dialog_message('Error in READ_LOC, localizefixedmask quitting'+string(10b)$
    +'OR the only spot found is the trivial spot', title='Error in localizefixedmaskButton')
    return
    endif

    mask=bytarr(info.xtot, info.ytot)
    mask[*, *]=0
    mask[transpose(round(fixed_mask_loc[0, *])), transpose(round(fixed_mask_loc[1, *]))]=1
    s=replicate(1, 2, 2)
    tvscl, dilate(mask, s), 0, 0, 1

spot_number=0
if (n_elements(fixed_mask_loc) GT 4) then begin
    select_spot_parameters={$
       locations:fixed_mask_loc, $
       groupleader:event.top, $
       ave_pic:ave_pic $
       }
    res=dialog_message('More than one spot.  Right click on preferred site.', title='Error in localizefixedmaskButton')
    spot=select_spot_window(select_spot_parameters)
    widget_control, event.top, get_Uvalue=temp
    spot_number=temp.spot_number
    ;print, spot_number
    endif

wset, drawID
erase
;****************generate the one true mask*******************************
;At this point, a spot has been selected -- either by the original ROI or the manual selection from many spots.
;For the rest of the calculation, we proceed with a SINGLE gaussian mask which operates on:
;1) the full image (if an ROI is NOT specified)
;2) the selected image (if an ROI is specified)

;cut_width=round(cutsize*psfwidth)
x_dim=pic_size[0];2.0*cut_width+1
y_dim=pic_size[1];2.0*cut_width+1

x0_ROI=0
y0_ROI=0

;check the validity of the ROI
    check1=n_elements(region)   ; = 4
    check2=(region[0] GE 0)     ;=1
    check3=(region[1] GE 0)  ;=1
    check4=(region[2]+region[0] LT x_dim)  ;=1
    check5=(region[3]+region[1] LT y_dim)  ;=1
    check6= total(region) GT 0          ;=1
    if (check1*check2*check3*check4*check5*check6 EQ 4) then begin
        x0_ROI=region[0]
        y0_ROI=region[1]
        x_dim=region[2]
        y_dim=region[3]
        ;region = 0
        endif else begin
        ;res=dialog_message(    'ROI is undefined or outside the boundaries of the image.'+string(10B)+$
        ;             'Proceeding with full field calculation.', title='region of interest in localizefixedmaskButton')
        endelse

x0=fixed_mask_loc[0, spot_number]+x_offspot-x0_ROI    ;
y0=fixed_mask_loc[1, spot_number]+y_offspot-y0_ROI

ave_pic=ave_pic(x0_ROI:x0_ROI+x_dim-1, y0_ROI:y0_ROI+y_dim-1)

gauss_mask=dblarr(x_dim, y_dim)
F=1.0/(sqrt(2.0)*psfwidth)

x_dim = long(x_dim)
y_dim = long(y_dim)
array=lindgen(x_dim, y_dim)
xarr=array mod x_dim
yarr=array/x_dim

;these lines draw a square to do the analysis instead of using a Gaussian Mask
;v1=20
;v2=23
;v3=5
;v4=8
;square=bytarr(x_dim, y_dim)
;square[v1,v3:v4]=255
;square[v2, v3:v4]=255
;square[v1:v2, v3]=255
;square[v1:v2, v4]=255

;photon calc scheme from the full least square fit
;N=0.0
;sum = 0.0
;image=reform(image, nx, ny, /overwrite)
;array=lindgen(nx, ny)
;xarr=array mod nx
;yarr=array/nx
;F=1.0/(sqrt(2.0)*psf_width)
;a=F*(yarr - 0.5 - parameters[2])
;b=F*(yarr + 0.5 - parameters[2])
;c=F*(xarr - 0.5 - parameters[1])
;d=F*(xarr + 0.5 - parameters[1])
;ls_mask =0.25*(errorf(a)-errorf(b))*(errorf(c)-errorf(d))
;sum = total(ls_mask*ls_mask)
;N = total(image*ls_mask)
;photon_number = N/sum

a=F*(yarr - 0.5 - y0)
b=F*(yarr + 0.5 - y0)
c=F*(xarr - 0.5 - x0)
d=F*(xarr + 0.5 - x0)
gauss_mask =0.25*(errorf(a)-errorf(b))*(errorf(c)-errorf(d))
sum = total(gauss_mask*gauss_mask)

tvscl, rebin(gauss_mask, 6*x_dim, 6*y_dim), 0, 0, 1
;tvscl, rebin(square, 6*x_dim, 6*y_dim), 0, 0, 1
tvscl, rebin(ave_pic, 6*x_dim, 6*y_dim), 0, 0, 2
tvscl, rebin(ave_pic, 6*x_dim, 6*y_dim), 6*x_dim, 0, 2

output_file=change_extension(info.picFilename, 'fix')
openw, 3, output_file, error=err
IF (err NE 0) then begin
    res=dialog_message(!ERROR_STATE.MSG, title='File error in localizefixmaskButton')
    close, 3
    return
    endif

;now begin the calculation of photon numbers in each frame
for i=first-1, last-1 do begin
    pic=read_tiff(info.picFilename, image_index=i)
    pic=pic(x0_ROI:x0_ROI+x_dim-1, y0_ROI:y0_ROI+y_dim-1)

    if locparameters.auto_black_level_val eq 0 then locparameters.blacklevel=median(pic)
     blksubtract=(pic-locparameters.blacklevel)

    if locparameters.auto_black_level_val EQ 2 then blksubtract=pic-local_background(pic)

    image=(blksubtract GT 0)*blksubtract
    N = total(image*gauss_mask)
    photon_number = N/sum;
;    photon_number = total(blksubtract[v1:v2, v3:v4]) ;THIS LINE IS NORMALLY NOT PRESENT.
    widget_control, info.outputlocalizeID, set_value=string(photon_number),/append, SET_TEXT_TOP_LINE=(i-1) > 0
    printf, 3, photon_number
endfor

;erase the previous values and reset any ROI which might have been drawn
info.selection_par=[-1, -1, -1, 0, 0, 0, 0]
widget_control, event.top, SET_uvalue=info, /no_copy
;note: if you want the ROI to be kept from run, to run, just remove the above line

close, 3
res=dialog_message('Fixed mask photons written to:'+output_file, title='Fixed mask calculation complete')
return
end
