PRO localizeParameterMenu, event

xs=300
ys=500
widget_control, event.top, GET_Uvalue=info

form = WIDGET_BASE(TITLE='Localize Parameter Window', xsize=xs, ysize=ys, group_leader=event.top,/column, /modal)
redparameterBase=widget_base(form, /frame, /col)
greenparameterBase=widget_base(form, /frame, /col)
blueparameterBase=widget_base(form, /frame, /col)
redfileID=cw_field(redparameterbase, title='red filename:', value='red filename')
redbpassID=cw_field(redparameterbase, title='red bpass', value=1.7, /floating)
redthresholdID=cw_field(redparameterbase, title='red threshold', value=200, /floating)

greenfileID=cw_field(greenparameterbase, title='green filename:', value='green filename')
greenbpassID=cw_field(greenparameterbase, title='green bpass', value=1.7, /floating)
greenthresholdID=cw_field(greenparameterbase, title='green threshold', value=200, /floating)

bluefileID=cw_field(blueparameterbase, title='blue filename:', value='blue filename')
bluelowerbpassID=cw_field(blueparameterbase, title='blue lower bpass', value=5.0, /floating)
bluebpassID=cw_field(blueparameterbase, title='blue upper bpass', value=20.0, /floating)
bluethresholdID=cw_field(blueparameterbase, title='blue threshold', value=200, /floating)

viewselectionBase=widget_base(form, /frame, /row)
redchannelviewID=cw_bgroup(viewselectionBase, ['red pic', 'red bpass'], /exclusive, event_func='redchannelView', /no_release)
greenchannelviewID=cw_bgroup(viewselectionBase, ['green pic', 'green bpass'], /exclusive, event_func='greenchannelView', /no_release)
bluechannelviewID=cw_bgroup(viewselectionBase, ['blue pic', 'blue bpass'], /exclusive, event_func='bluechannelView', /no_release)
viewmultichannelmaskID=widget_button(form, value='view', event_pro='viewcompositeMask')
assignmultichannelmaskID=widget_button(form, value='assign multichannel mask', event_pro='assigncompositeMask', sensitive=0)

frameID=cw_field(form, title='frame:', value=1, /floating)

;viewmultichannelmaskID=widget_button(form, value='view composite mask', event_pro='viewcompositeMask')

channel=0b
maskinfo={$
    drawID:info.drawID, $
    redfileID:redfileID, $
    redbpassID:redbpassID, $
    redfilename:'red temp', $
    redthresholdID:redthresholdID, $
    greenfileID:greenfileID, $
    greenbpassID:greenbpassID, $
    greenfilename:'green temp', $
    greenthresholdID:greenthresholdID, $
    bluefileID:bluefileID, $
    bluebpassID:bluebpassID, $
    bluelowerbpassID:bluelowerbpassID, $
    bluefilename: 'blue temp', $
    bluethresholdID:bluethresholdID, $
    frameID:frameID, $
    channel:channel, $        ;bit
    assignmultichannelmask:info.assignmultichannelmask $    ;0=no mask assigned, 1=multichannel mask assigned
          }

widget_control, form, Set_Uvalue=maskinfo, /no_copy

height = max(widget_height(form))
widget_control, redparameterbase, ysize=0.18*height
widget_control, greenparameterbase, ysize=0.18*height
widget_control, blueparameterbase, ysize=0.24*height
widget_control, viewselectionBase, ysize=0.15*height
;widget_control, drawBase, ysize=height

WIDGET_CONTROL, form, /REALIZE
XMANAGER, 'localizeParameterMenu', form, /NO_BLOCK
end