;PRO zeiss5__define
;   tmp = {zeiss5, $
;            magic:0l,  $
;            size:0l,  $
;            x_dim:0l,  $
;            y_dim:0l,  $
;            z_dim:0l,  $
;            channels:0l,  $
;            t_dim:0l,  $
;            datatype:0l,  $
;            thumb_x_dim:0l,  $
;            thumb_y_dim:0l,  $
;            x_size:0.d,  $
;            y_size:0.d,  $
;            z_size:0.d,  $
;            scantype:0l, $
;            c_datatype:0l,  $
;            offs_vectoro: 0l,  $
;            offs_inlut: 0l,  $
;            offs_outlut:0l,  $
;            offs_channelcol:0l,  $
;            timeint:0.d,  $
;            offs_chandatatypes:0l,  $
;            offs_scaninfo:0l,  $
;            offs_ksdata:0l,  $
;            offs_timestamps:0l,  $
;            offs_eventlist:0l,  $            
;            offs_roi:0l,  $            
;            offs_bleachroi:0l,  $            
;            offs_nextrec:0l,  $            
;            reserved:lonarr(90)}
; END   

FUNCTION lsm_data_read_conv, resu, lun, x_offset, $
                        samples, stripbytec, stripoffsets, bitspersample
   FOR i=0, samples-1 DO BEGIN
     CASE bitspersample[i] OF
       16: data = intarr(stripbytec[i]/2)
       32: data = lonarr(stripbytec[i]/4)
       ELSE: data = bytarr(stripbytec[i])
     ENDCASE
     point_lun, lun, stripoffsets[i]+x_offset
     readu, lun, data
     IF (bitspersample[i] NE 8) and (!version.arch ne 'x86') THEN data = swap_endian(data)
     IF n_elements(resu) LE 1 THEN resu = temporary(data) $
     ELSE resu = [[resu], [temporary(data)]]
   ENDFOR
   return, resu
END

FUNCTION lsm_value_read_alone, direntry, lun, x_offset
   CASE direntry.type OF
     3:typlen = 2
     4:typlen = 4
     5:typlen = 4;?
     ELSE:typlen = 1
   ENDCASE
   IF direntry.length*typlen LE 4 THEN BEGIN
     CASE direntry.type OF
       1: val = byte(direntry.value)
       2: val = string(direntry.value)
       3: val = fix(direntry.value)
       4: val = long(direntry.value)
       5: val = float(direntry.value)
     ELSE: val = byte(direntry.value)
   ENDCASE
   ENDIF ELSE BEGIN
     point_lun, lun, direntry.value+x_offset
     CASE direntry.type OF
       3:val = intarr(direntry.length)
       4:val = lonarr(direntry.length)
       5:val = fltarr(direntry.length)
       ELSE:val = bytarr(direntry.length)
     ENDCASE
     IF direntry.tag EQ 34412u THEN val = {zeiss5}
     readu, lun, val
     IF direntry.type EQ 2 THEN val = string(val) $
     ELSE if !version.arch ne 'x86' then val = swap_endian(val)
   ENDELSE
   return, val
 END

FUNCTION lsm_read_point_alone, lun, x_offset, ZEISS=lminfo, PLANAR=planar, THUMBNAIL=tum

   tiff_head = {tiff_head, byteorder:0u, identifier:0u, offset:0ul}
   readu, lun, tiff_head
   if !version.arch ne 'x86' then tiff_head = swap_endian(tiff_head)
   if (tiff_head.offset eq 0ul) and (x_offset ne 0ul) then return,-1l

   img_dir = {img_dir, tag:0u, type:0u, length:0ul, value:0ul}
   ntags = 0u
   offs = 0ul
   offset = tiff_head.offset

   tum = 0
   tumz = 0
   resu = 0
   resuz = 0

   REPEAT BEGIN
     readu, lun, ntags
     if !version.arch ne 'x86' then ntags = swap_endian(ntags)

     dir = replicate(img_dir, ntags)
     readu, lun, dir
     readu, lun, offset
     if !version.arch ne 'x86' then offset = swap_endian(offset)
     if !version.arch ne 'x86' then dir = swap_endian(dir)
     FOR i=0, ntags-1 DO CASE dir[i].tag OF
       254u:newsubfiletype = lsm_value_read_alone(dir[i], lun, x_offset)
       256u:imagewidth = lsm_value_read_alone(dir[i], lun, x_offset)
       257u:imagelength = lsm_value_read_alone(dir[i], lun, x_offset)
       258u:bitspersample = lsm_value_read_alone(dir[i], lun, x_offset)
       259u:compression = lsm_value_read_alone(dir[i], lun, x_offset)
       262u:photo = lsm_value_read_alone(dir[i], lun, x_offset)
       ;271u:producer = lsm_value_read_alone(dir[i], lun, x_offset)
       ;272u:microscope = lsm_value_read_alone(dir[i], lun, x_offset)
       273u:stripoffsets = lsm_value_read_alone(dir[i], lun, x_offset)
       277u:samples = lsm_value_read_alone(dir[i], lun, x_offset)
       279u:stripbytec = lsm_value_read_alone(dir[i], lun, x_offset)
       284u:planar = lsm_value_read_alone(dir[i], lun, x_offset)
       ;305u:zif_vers = lsm_value_read_alone(dir[i], lun, x_offset)
       317u:predictor = lsm_value_read_alone(dir[i], lun, x_offset)
       320u:colormap = lsm_value_read_alone(dir[i], lun, x_offset)
       34412u:lminfo = lsm_value_read_alone(dir[i], lun, x_offset)
       ELSE:print, dir[i]
     ENDCASE

if compression EQ 5 then return, -1

;*****************************************
;DEBUGGING code
;print, 'newsubfiletype:', newsubfiletype
;print, 'image dim:', imagewidth, imagelength
;print, 'bits per sample:', bitspersample
;print, 'compression:', compression
;print, 'photo:', photo
;print, 'strip offsets:', stripoffsets
;print, 'samples:', samples
;print, 'strip byte rec:', stripbytec
;print, 'planar:', planar
;print, 'predictor:', predictor

;******************************************
     CASE newsubfiletype OF
       0:BEGIN
         resuz = resuz+1
         resuwidth = imagewidth
         resulength = imagelength
         ;resubits = bitspersample    ;IS THIS LINE NEEDED? VARIABLE EVER USED?
         resusamples = samples
         resu = lsm_data_read_conv(resu, lun, x_offset, samples, $
                              stripbytec, stripoffsets, bitspersample)
       END
       1:IF arg_present(tum) THEN BEGIN
         tumz = tumz+1
         tumwidth = imagewidth
         tumlength = imagelength
         tumbits = bitspersample
         tumsamples = samples
         tum = lsm_data_read_conv(tum, lun, x_offset, samples, $
                             stripbytec, stripoffsets, bitspersample)
    ENDIF
       ELSE:
     ENDCASE
     IF offset NE 0 THEN point_lun, lun, offset+x_offset
    ENDREP UNTIL offset EQ 0  ;THIS is the original line
   IF n_elements(resu) GT 0 THEN $
    resu = reform(resu, resuwidth, resulength, resusamples, resuz, /over)
   IF arg_present(tum) AND (n_elements(tum) GT 0) $
     AND (size(tum, /n_dim) NE 0) THEN $
    tum = reform(tum, tumwidth, tumlength, tumsamples, tumz, /over)

   return, resu
 end

FUNCTION lsm_read_alone, name, ZEISS=lminfo, PLANAR=planar, THUMBNAIL=tum, NEXT_RECORDING=nxrec

   inxrec=keyword_set(nxrec)?nxrec:0l

   openr, lun, name, /get_lun

   offset=0ul

  resu=lsm_read_point_alone(lun, offset, ZEISS=lminfo, PLANAR=planar, THUMBNAIL=tum)

  if resu[0] EQ -1 then begin
    print, '*********LZW compression not supported.************'
    return, -1
    endif

   if (n_elements(resu) eq 1) and (resu[0] eq -1l) then message,'No image found'
   nxcount=0
   while (inxrec gt 0) do begin
     if lminfo.offs_nextrec ne 0ul then begin
       point_lun, lun, lminfo.offs_nextrec
       resu1=lsm_read_point_alone(lun, lminfo.offs_nextrec, ZEISS=lminfo, PLANAR=planar, THUMBNAIL=tum)
       if not((n_elements(resu1) eq 1) and (resu1[0] eq -1l)) then begin
         resu=resu1
         inxrec = inxrec-1
         nxcount=nxcount+1
       endif else begin
         message,'No second image found',/continue
         inxrec = 0
         nxcount= 0
       endelse
     endif else inxrec=0l
   endwhile
   nxrec=nxcount

   free_lun, lun

   return, reform(resu, /over)
 END

function channel_select_lsm, event
widget_control, event.top, get_uvalue=parameters
parameters.channel=event.value
;if event.value eq 0 then print, 'channel 1'
;if event.value eq 1 then print, 'channel 2'
;if event.value eq 2 then print, 'both'

widget_control, event.top, set_uvalue=parameters, /no_copy

return, 1
end

pro multiple_lsm_Open_alone, event

file = DIALOG_PICKFILE(/READ, FILTER = '*.lsm', dialog_parent=event.top, /multiple_files, get_path=file_path)
if file[0] eq '' then return
cd, file_path
n=n_elements(file)
widget_control, event.top, GET_Uvalue=lsm_ipl_info
WIDGET_CONTROL, lsm_ipl_info.tableID, SET_VALUE=transpose(file), USE_TABLE_SELECT=[0,0,0,n-1]
return
end

pro lsm_ip_convert_alone, event

widget_control, event.top, GET_Uvalue=lsm_pic_info
widget_control, lsm_pic_info.tableID, get_value=files
file_cull=files(where(files NE ''))
number_stacks= n_elements(file_cull)

;In this conversion utility, unlike the tif --> ipl converstion utility, each LSM
;image is assumed to be an image stack.  Therefore, each file is converted to it's own
;IPL file rather than concatenating them togeher into one time series

for i=0, number_stacks-1 do begin
  raw_pic=uint(lsm_read_alone(file_cull[i]))
  if raw_pic[0] EQ 65535 then begin
    res=dialog_message('File conversion error.  Unable to read lsm file.', title='File error in  lsm_ip_convert_alone')
    return
    endif
  a=size(raw_pic, /dimensions)

if n_elements(a EQ 3) then begin    ;the LSM file format is annoying.  For multi channel data, the pic data is 4 dimensional.
  pic=uintarr(a[0], a[1], 1, a[2])  ;For single channel data, the pic is 3 dimensional.
  pic[*, *, 0, *]=raw_pic[*, *, *]  ;Make ALL the pic matrices 3 dimensionsal.
  endif else pic=raw_pic

  a=size(pic, /dimensions)
  frames=a[3]

s=strlen(file_cull[i])
base_file=strmid(file_cull[i], 0, s-4)
CASE lsm_pic_info.channel OF      ;by using the CASE format, it will be easier to scale up to more channels
  0: pic_filename=base_file+'_ch1.ipl'
  1: pic_filename=base_file+'_ch2.ipl'
  ENDCASE
  info={pic:pic[*,*,0,0], filename:pic_filename, zplanes:1, tvolumes:frames}  ;The first pic is not written during
  res=write_ipl(info, /open)                          ;the write_ipl(info, /open) operation.
                                        ;It is a place holder.
  widget_control,lsm_pic_info.outputlocalizeID, set_value=pic_filename, /append
    for j= 0, frames-1 do begin
      CASE lsm_pic_info.channel OF
      0:info.pic=pic[*,*,0,j]
      1:info.pic=pic[*,*,1,j]
      ENDCASE
        res=write_ipl(info, /append)
          endfor

    ;now close the generated pic file
    res=write_ipl(info, /close)
    endfor

output_dir=strmid(base_file, 0, strpos(base_file, '\', /reverse_search))
res=dialog_message('All files written with base directory:'+string(10B)+output_dir, title='Conversion complete')

return
end

pro lsm_ipl_standalone, event

maxysize=1000
;widget_control, event.top, GET_Uvalue=main_parameters
form = WIDGET_BASE(TITLE='lsm  --> ipl', xs=450, ys=515, /column)
openID=widget_button(form, value='Open', Event_pro='multiple_lsm_Open_alone')
upID=widget_button(form,value='up', Event_pro='file_up')
downID=widget_button(form, value='down', Event_pro='file_down')

tableID = WIDGET_table(form,xsize=1, ysize=maxysize, scr_xsize=400, scr_ysize=350, $
    /scroll, /resizeable_columns, column_width=350)

channelBase=widget_base(form, /row)
textID=widget_label(channelBase, value='channel select:')
channelID=cw_bgroup(channelBase, ['1', '2'], column=2, /exclusive, event_func='channel_select_lsm', /no_release)
text1ID=widget_label(channelBase, value='(default = 1)')
convertID=widget_button(form, value='Convert', event_pro='lsm_ip_convert_alone')
doneID=widget_button(form, value='Done', event_pro='lsm_pic_done')

WIDGET_CONTROL, form, /REALIZE

lsm_ipl_info={$
             tableID:tableID, $
             channel:0 $  ;default value = channel 1 (i.e. the only channel in a single channel exp)
           }

widget_control, form, Set_Uvalue=lsm_ipl_info, /no_copy


XMANAGER, 'lsm_ipl', form, /NO_BLOCK

return
end