FUNCTION output_center, pic, loc, mag, peak_white, channel, writetiff=writetiff

erase
b=size(pic, /dimensions)
count=n_elements(loc)/3
int_loc=round(loc)
mask=bytarr(b[0], b[1])
clear=bytarr(b[0], b[1])

for i =0, count -1 do begin
    mask(int_loc[0, i]:int_loc[0, i]+1, int_loc[1, i]:int_loc[1, i]+1) = 1
endfor

x_redim=b[0]/mag
y_redim=b[1]/mag
blue=rebin(mask, x_redim, y_redim)
s=replicate(1, 3, 3)

raw_image=rebin(pic, x_redim, y_redim)
contrast_index=where(raw_image GE peak_white)
contrast_index=abs(contrast_index)
raw_image(contrast_index) = peak_white
;tvscl, dilate(blue, s), 0, 0, 0

;make a square mask
square_mask=bytarr(b[0], b[1])
half_square=5
for k = 0, count-1 do begin
  left_x=int_loc[0,k]-half_square GT 0 ? int_loc[0,k]-half_square : 0
  right_x=int_loc[0,k]+half_square LT b[0]-1 ? int_loc[0,k]+half_square : b[0]-1
  bottom_y=int_loc[1, k]-half_Square GT 0 ? int_loc[1, k]-half_Square : 0
  top_y= int_loc[1, k]+half_square LT b[1]-1 ? int_loc[1, k]+half_square : b[1]-1

  square_mask(left_x, bottom_y:top_y)=1
  square_mask(right_x, bottom_y:top_y)=1
  square_mask(left_x:right_x, top_y)=1
  square_mask(left_x:right_x, bottom_y)=1
  endfor

tvscl, square_mask, 0, 0, 0
tvscl, raw_image, 0, 0, channel+1


;this line dilates the mask for the output tiff
blue=dilate(blue, s)

if keyword_set(writetiff) then begin
    color_merge=uintarr(3, b[0], b[1])
    color_merge[0, *, *]=scale_pic(blue*max(raw_image))
    color_merge[1, *, *]=scale_pic(raw_image)
    write_tiff, 'output center.tif', color_merge, /short
endif
return, 1
end