FUNCTION read_ipl, filename, pic, frame_input, FrameInfo=frameInfo, Info = info

; This program reads the IP Lab image format.
; note: see the file 'IPLab file format.pdf'
;
; example:
; pic=dblarr(768, 512)
; read_pic, 'c:\data\idl\test.pic', pic, number  (where number is the particular frame in a time series, projection, etc.)
; window, xsize=768, ysize=512
; tvscl, pic, /order
;
; Dan Larson
; 5/5/04

;variables to be read
intel='xxxx'
data='xxxx'
ssize=0l
x_pixel=0l
y_pixel=0l
color=0l
zplanes=0l
tvolumes=0l
data_type=0l
finish='xxxx'

frame_number=uint(frame_input)
openr, 1, filename, error=err, /swap_if_big_endian
IF (err NE 0) then begin
    res=dialog_message(!ERROR_STATE.MSG, title='File error in READ_IPL')
    pic=-1
    return, -1
    endif
;read the header

readu, 1, intel         ;checks for intel or motorola byte ordering
readu, 1, ssize         ;the size of tag block
res2=SWAP_ENDIAN(ssize, /SWAP_IF_BIG_ENDIAN)
POINT_LUN, -1, pos   ;check the current position within the file
point_lun, 1, pos+ssize ;move the file pointer past the point specified in ssize
readu, 1, data       ;read the 'data' string indicating position of data
readu, 1, ssize        ;the size of data block
res2=SWAP_ENDIAN(ssize, /SWAP_IF_BIG_ENDIAN)
readu, 1, x_pixel     ; width
res2=SWAP_ENDIAN(x_pixel, /SWAP_IF_BIG_ENDIAN)
readu, 1, y_pixel     ; height
res2=SWAP_ENDIAN(y_pixel, /SWAP_IF_BIG_ENDIAN)
readu, 1, color        ;1 = grayscale 3 = RGB color
res2=SWAP_ENDIAN(color, /SWAP_IF_BIG_ENDIAN)
readu, 1, zplanes     ; number of zplanes
res2=SWAP_ENDIAN(zplanes, /SWAP_IF_BIG_ENDIAN)
readu, 1, tvolumes   ;number of t volumes
res2=SWAP_ENDIAN(tvolumes, /SWAP_IF_BIG_ENDIAN)
readu, 1, data_type     ;data type
res2=SWAP_ENDIAN(data_type, /SWAP_IF_BIG_ENDIAN)

if data_type NE 2 then begin
    close, 1
    res=dialog_message('this data is not 16 bit data -> file may not read correctly', $
        title='File error in READ_IPL')
    return, -1
    endif
point_lun, -1, pos

IF KEYWORD_SET(INFO) THEN BEGIN
print, 'x pixel: ', x_pixel
print, 'y pixel: ', y_pixel
print, 'color (1=grayscale; 3=RGB):', color
print, 'z planes: ', zplanes
print, 'T volumes:', tvolumes
print, 'data type:', data_type
endif

if keyword_set(frameInfo) then begin
    close, 1
    framestructure={tvolumes:tvolumes, zplanes:zplanes, xdim:x_pixel, ydim:y_pixel}
    return, framestructure
    endif

;associate image file with a variable
image=assoc(1, uintarr(x_pixel, y_pixel), pos)
pic=image[frame_number]

res2=SWAP_ENDIAN(pic, /SWAP_IF_BIG_ENDIAN)

close, 1
return, 1
end
