FUNCTION read_loc, filename

;Reads the *.loc file from localize.pro
;Dan Larson
;10/25/02

openr, 1, filename, error=err

; If err is nonzero, something happened. Print the error message to
; the standard error file (logical unit -2):
IF (err NE 0) then begin
    res=dialog_message(!ERROR_STATE.MSG, title='File error in READ_LOC')
    return, -1
    endif

lines=file_lines(filename)
temp = dblarr(4, 1)
loc = dblarr(4, lines)
m = 0L
while not eof(1) do begin
    readf, 1, FORMAT = '(4(d0.3, "  "))', temp
    loc[*, m] = temp
    m = m+1
    endwhile
close, 1

;since there is now a reverse localize, there needs to be a sorting step before returning the data
loc_sort=loc
a=sort(loc[3, *])
loc_sort=loc[*, a]
return, loc_sort
end