FUNCTION read_trk, filename

;Reads the *.trk file from localize.pro
;Dan Larson
;10/25/02

openr, 1, filename, error=err

; If err is nonzero, something happened. Print the error message to
; the standard error file (logical unit -2):
IF (err NE 0) then begin
    res=dialog_message(!ERROR_STATE.MSG, title='File error in READ_TRK')
    return, -1
    endif

lines=file_lines(filename)
temp = dblarr(5, 1)
trk = dblarr(5, lines)
m = 0L
while not eof(1) do begin
    readf, 1, FORMAT = '(5(d0.3, "  "))', temp
    trk[*, m] = temp
    m = m+1
    endwhile
close, 1
return, trk
end