PRO smallWindowGaussianFit, event

xs=200
ys=200
widget_control, event.top, GET_Uvalue=info
widget_control, info.drawID, get_value=main_window

;make the window and realize the widget
form = WIDGET_BASE(TITLE='Gaussian Fit', xsize=3*xs, ysize=1.5*ys, group_leader=event.top,/column, /modal)
smallwindowdrawID = widget_draw(form, /frame, x_scroll=2.8*xs, y_scroll=ys, xsize=4*xs, ysize=ys, /scroll)
averageWidthID = cw_field(form, title='average 2D width', value=0.0, /floating)
height = max(widget_height(form))
widget_control, form, ysize=1.2*height
WIDGET_CONTROL, form, /REALIZE
widget_control, smallwindowdrawID, get_value=small_window
wset, small_window

;read the image
pic=read_tiff(info.picFilename, image_index=info.frameindex)
;
NX=info.selection_par[5]-info.selection_par[3]+1
NY=info.selection_par[6]-info.selection_par[4]+1

if (NX + NY) LT 4 then begin
	res=dialog_message('Make a ROI selection.', title='Error in smallWindowGaussianFit')
	return
	endif
selection=dblarr(NX, NY)
selection(*, *)=pic[info.selection_par[3]:info.selection_par[5], info.selection_par[4]:info.selection_par[6]]
res=gauss2dfit(selection, a)
tvscl, rebin(selection, NX*6, NY*6), 0, 0, 1
tvscl, rebin(res, NX*6, NY*6), 0, 0, 2
tvscl, rebin(selection, NX*6, NY*6), NX*6, 0, 0
tvscl, rebin(res, NX*6, NY*6), NX*6*2, 0, 0
tvscl, 0*selection, 0, 0, 3
;       print, 'averaged psf width:', (a[2]+a[3])/2.0
;       print, 'scale factor:', a[1]
;       print, 'total counts from inset:',total(selection)
widget_control, averageWidthID, set_value=(a[2]+a[3])/2.0

;erase the previous values and reset the ROI
info.selection_par=[-1, -1, -1, 0, 0, 0, 0]

;erase the original ROI
wset, main_window
tvscl, 0*pic, 0,0,3

widget_control, event.top, SET_uvalue=info, /no_copy
;note: if you want the ROI to be kept from run, to run, just remove the above line

widget_control, form, Set_Uvalue=maskinfo, /no_copy


XMANAGER, 'smallWindowGaussianFit', form, /NO_BLOCK
return
end

