FUNCTION write_ipl, info, open=open, append=append, close=close

; This program writes an array to an IPLAB file.
; The format of the input array should be (x, y)
; note: pic must be a two-dimensional array.  If there is a zseries, each array
; must be added separately using the APPEND keyword
; Dan Larson
; 11/27/06
;
;Modification history
;
;format of the info structure:
;
;pic = the array which hold the image
;filename = the filename of the IPL file
;zplanes = # of zplanes
;tvolumes = # time points

a=size(info.pic)
x_dim = long(a[1])
y_dim = long(a[2])

filename=info.filename
pic=info.pic
zplanes=long(info.zplanes)
tvolumes=long(info.tvolumes)
data_type=2l
version=[49B, 48B, 48B, 103B]

if keyword_set(open) then begin
    openw, 4, filename, error=err
    IF (err NE 0) then begin
        res=dialog_message(!ERROR_STATE.MSG, title='File error in WRITE_IPL')
        return, -1
        endif

       ;write the header
       ssize=long(x_dim*y_dim*zplanes*tvolumes*data_type+28) ;this is the size of the data block
                                         ;the data type is usually 2, meaning 16 bit (2 byte) data
                                         ;the 28 extra bytes comes from the 7 long variables after the
                                         ;data declaration : 1) ssize 2) x_pixel 3) y_pixel 4) color 5) zplanes
                                         ;6)t volumes 7)data type
       writeu, 4, 'iiii'    ;write the intel or motorola byte ordering
       writeu, 4, 4l        ;the size of tag block
       writeu, 4, string(version)
       writeu, 4, 'data'    ;read the 'data' string indicating position of data
       writeu, 4, ssize     ;the size of data block
       writeu, 4, x_dim     ;width
       writeu, 4, y_dim     ;height4
       writeu, 4, 1L     ;1 = grayscale 3 = RGB color
       writeu, 4, zplanes   ; number of zplanes
       writeu, 4, tvolumes   ;number of t volumes
       writeu, 4, data_type       ;data type
       return, 1
       endif

if keyword_set(append) then begin
    writeu, 4, pic
    endif

if keyword_set(close) then begin
    writeu, 4, 'fini'
    writeu, 4, 0L
    close, 4
    return, 1
    endif
return, 1
end