FUNCTION write_pic, filename, pic, number_frames, open=open, append=append, close=close

; This program writes an array to a Bio_Rad pic file.
; The format of the input array should be (x, y)
; note: pic must be a two-dimensional array.  If there is a zseries, each array
; must be added separately using the APPEND keyword
; Dan Larson
; 7/7/03
;
;Modification history
;
;DRL 12/19/04.  Modified to write word pixels instead of byte pixels.  Modification
;works fine for localize routines, but pic files can't be read by confocal assistant.
a=size(pic)
x_dim = uint(a[1])
y_dim = uint(a[2])


if keyword_set(open) then begin
    openw, 3, filename, error=err
    IF (err NE 0) then begin
    res=dialog_message(!ERROR_STATE.MSG, title='File error in WRITE_PIC')
    return, -1
    endif

    writeu, 3, x_dim   ; x pixel
    writeu, 3, y_dim   ; y pixel
    writeu, 3, uint(number_frames)   ; number of frames
    writeu, 3, uint(0)   ; contrast ramp 0 (full black)
    writeu, 3, uint(255) ; contrast ramp 255 (peak white)
    writeu, 3, ulong(0) ; space filler
    writeu, 3, uint(0)   ; image type: 1=byte pixels, 0=word pixels
    writeu, 3, intarr(17) ; space filler
    writeu, 3, uint(0)   ; merged images
    writeu, 3, uint(1)   ; low byte for RGB colors
    writeu, 3, uint(12345); check for a pic file. Default = 12345
    writeu, 3, uint(0)   ; contrast ramp for second channel (full black)
    writeu, 3, uint(255) ; contrast ramp for second channel (peak white)
    writeu, 3, uint(2)   ; low byte for RGB color of second picture of merged pair
    writeu, 3, uint(0)   ; space filler
    writeu, 3, uint(63)  ; lens power
    writeu, 3, float(3.0) ; mag factor
    writeu, 3, bytarr(6)   ; space filler
    ;point_lun, 3, 76
    writeu, 3, pic
    endif

if keyword_set(append) then begin
    writeu, 3, pic
    endif

if keyword_set(close) then begin
    close, 3
    return, 1
    endif
return, 1
end