function platePos = pnkComputeIntersection(platePos);

    
%Calculate point of intersection of spindle axis with metaphase plate
 
normalVector = [2 0 0]; %Create a vector normal to the plane
 
pointOnPlane = [0 0 5]; %Create a point on the plane
 
for t = 1:length(platePos.pole1)
    
 % R = A + d (B - A) where  R is the point of intersection between the plate and spindle axis, 
 % and falls along the line AB, at a distance d away from A.
 
 platePos.intersectRatio(t) = dot(pointOnPlane - platePos.pole1(t,1:3), normalVector) / dot(platePos.pole2(t,1:3) - platePos.pole1(t,1:3), normalVector);
 
 platePos.pointofIntersection(t,1:3) = platePos.pole1(t,1:3) + platePos.intersectRatio(t)*(platePos.pole2(t,1:3)-platePos.pole1(t,1:3));
 
 platePos.platePosition(t) = platePos.intersectRatio(t)*100; %percent distance of plate from 2-centriole/GM pole
 
 platePos.spindleRatio(t) = platePos.intersectRatio(t)/(1-platePos.intersectRatio(t)); %ratio of 2c/GM half-spindle length to 1c/M half-spindle length.
 
end

