function platePos = pnkFindPoles(Analysis, Data);


poleBuffer = zeros(Analysis.nTimepoints,3);

for t = 1:Analysis.nTimepoints %go through all time points
    
    pole1Limit = 3;    % Set minimum x-distance of spindle pole from the plane  
    
    for i=1:length(Data.planeFit(t).planeCoord)
        [findPole,index] = max(Data.planeFit(t).planeCoord(:,1));
       
        if findPole < pole1Limit
            platePos.pole1(t,1:3) = NaN; % no pole found
        else 
            platePos.pole1(t,1) = findPole;
            platePos.pole1(t,2) = Data.planeFit(t).planeCoord(index,2);
            platePos.pole1(t,3) = Data.planeFit(t).planeCoord(index,3);
        end         
    end
    
    pole2Limit = -3;    % Set minimum distance of spindle pole from the plane  
    
    for i=1:length(Data.planeFit(t).planeCoord)
        [findPole,index] = min(Data.planeFit(t).planeCoord(:,1));
       
        if findPole > pole2Limit
            platePos.pole2(t,1:3) = NaN; % no pole found
        else 
            platePos.pole2(t,1) = findPole;
            platePos.pole2(t,2) = Data.planeFit(t).planeCoord(index,2);
            platePos.pole2(t,3) = Data.planeFit(t).planeCoord(index,3);
        end         
    end
end