function [Analysis] = pnkPlatePosition(Data, Analysis);  

%ANALYSIS = PNKPLATEPOSITION( )

%Check if there is data from tracking analysis
 

platePos = pnkFindPoles(Analysis, Data); % Identify poles

if isfield(platePos,'pole1')==0 || isfield(platePos,'pole2')==0 
   error('Error: Cannot detect centrioles')
end 

if isempty(platePos.pole1)==1 || isempty(platePos.pole2)==1
    error('Error: Cannot detect centrioles')
end


platePos = pnkComputeIntersection(platePos);

platePos = pnkRefPole(platePos);    

platePos = pnkSpindleLength(platePos);


% Plot & save results 

pnkPlotPlatePosition(platePos, Analysis);

Analysis.platePos = platePos;

Analysis.spindleLength = platePos.spindleLength;