function pnkPlotPlatePosition(platePos, Analysis);
 

%open figure and write title

set(0,'defaultfigurecolor',[1 1 1]);

figFileName = ['PlatePosition_' Analysis.outputFilename '.fig']; 
figHandle = figure('Name',figFileName,'NumberTitle','off');

subplot(2,2,1);
box on
hold on

plot(platePos.halfSpindle1(1,:), 'r') % Plots 2 centriole centrosome in red
plot(platePos.halfSpindle2(1,:)) % PLots 1 centriole centrosome

hold off

%write axes labels
        xlabel('Time Frame');
        ylabel('Half-spindle length (um)');

subplot(2,2,2);
plot(platePos.spindleLength(1,:)) % Plots total centrosome distances


%write axes labels
        xlabel('Time Frame');
        ylabel('Pole-to-pole distance (um)');
 
subplot(2,2,3);  
plot(platePos.platePosition(1,:)) % Plots plate position as percentage

axis([-Inf Inf 30 70 ]);

%write axes labels
        xlabel('Time Frame');
        ylabel('Plate position (%)');

        
% Save figure in set directory
saveas(figHandle,fullfile(Analysis.dir2SaveRes,figFileName),'fig');

Analysis.platePos = platePos;