function platePos = pnkRefPole(platePos);
    

firstGoodFrame = min(find(~isnan(platePos.platePosition)));

% Construct a questdlg with three options
whichRefPole = questdlg('Which half-spindle is longer? \nUse t=1 as reference',...
    'Select the reference pole',...
    '2c or GM pole','1c or M pole','Does not matter','2c or GM pole' );

% Handle response
switch whichRefPole
    case '2c or GM pole'
        platePos.referencePole = 2;
    case '1c or M pole'
        platePos.referencePole = 1;
    case 'Does not matter'
        platePos.referencePole = 2;
end


 
if platePos.referencePole == 2  % If 2c/GM pole has longer half-spindle
  if platePos.platePosition(firstGoodFrame) < 50
        %swap pole 1 & 2 coords
        poleBuffer = platePos.pole2; 
        platePos.pole2 = platePos.pole1;
        platePos.pole1  = poleBuffer;
        
        %change reference pole for plate position
        platePos.platePosition = 100 - platePos.platePosition;
        platePos.spindleRatio = 1+(1-platePos.spindleRatio);
    end
end

if platePos.referencePole == 1  % If 1c/M pole has longer half-spindle
        
    if platePos.platePosition(firstGoodFrame) > 50
        %swap pole 1 & 2 coords
        poleBuffer = platePos.pole2; 
        platePos.pole2 = platePos.pole1;
        platePos.pole1  = poleBuffer;
        
        %change reference pole for plate position
        platePos.platePosition = 100 - platePos.platePosition;
        platePos.spindleRatio = 1+(1-platePos.spindleRatio);
    end
end
