function appendSucroseLog(logMessage, level)
%appendSucroseLog log a string to the log file
%   append logStr to the log file and use level to indicate the amount of
%   urgency required (displayed using a color tag)

hMain = getappdata(0, 'h_sucrose');

if isempty(hMain)
    return;
end

if nargin == 1
    level = 'none';
end

level = lower(level);
logfile = getappdata(hMain, 'logfile');

if exist(logfile, 'file') ~= 2
    %file was not there, problem?
end

%store the string
try
    %check the input
    if isempty(logMessage) || iscell(logMessage)
        logMessage = [datestr(now) ': #####'];
    else
        %not empty, check if it's an exception type
        if isa(logMessage, 'MException')
            %this message is a struct, check for message field
            msgStk = logMessage.stack;
            if isempty(msgStk)
                logMessage = logMessage.message;
            else
                msgStk  = msgStk(1);
                [~, funName, ~] = fileparts(msgStk.file);
                logMessage      = ['line ' num2str(msgStk.line) ' in file ''' funName ''''];
            end
            %make sure level is set to urgent
            level      = 'urgent';
        elseif isnumeric(logMessage)
            logMessage = num2str(logMessage);
        end
    end
    
    %replace endlines with spaces
    logMessage = strrep(logMessage, '\r\n', ' ');
    logMessage = strrep(logMessage, '  ', ' ');
    
    %write the string to the end of the file
    fid = fopen(logfile, 'a');
    
    switch(level)
        case 'critical'
            %love red: e41b17
            logMessage = ['<html><font color="e41b17">' datestr(now), ': ', logMessage '</html>'];
        case 'urgent'
            %Construction Cone Orange: f87431
            logMessage = ['<html><font color="f87431">' datestr(now), ': ', logMessage '</html>'];
        case 'abnormal'
            %blue gray: 98afc7
            logMessage = ['<html><font color="98afc7">' datestr(now), ': ', logMessage '</html>'];
        case 'info'
            %zombie green: 54c571
            logMessage = ['<html><font color="54c571">' datestr(now), ': ', logMessage '</html>'];
        otherwise
            %default value for color is black
            logMessage = ['<html><font color="black">' datestr(now), ': ', logMessage '</html>'];
    end
    
    fprintf(fid, '%s\r\n', logMessage);
    %finished writing, close file
    fclose(fid);
    
catch me
    try
        if ~isempty(fid)
            fclose(fid);
        end
        return;
    catch meAgain
        disp(getReport(meAgain, 'basic'));
        return;
    end
end

end

