function [dataStruct] = createDataStructDefinition(fcv)
%CREATEDATASTRUCTUREDEFINITION This function creates an empty data
%structure depending on the file container version supplied via fcv.
%
%See also: sucrose_GUI_v2.m, extractSucrosePulses.m

%{
    This switch holds the definitions of the data structure for each file
    container version from 3.1 onwards. In future releases, the number of
    cases may increase to provide for extensions in the analysis software.
%}
switch(fcv)
    case {3.1, 3.2, 3.3}
        %create an empty data structure for storage in file container
        %version (fcv) 3.1, 3.2 and 3.3
        dataStruct = struct('filename', [],...
            'linkedFile', [],...
            'pathname', [],...
            'groupname', [],...
            'genotype', [],...
            'concentration', [],...
            'rawdata', [],...
            'nrOfBlocks', [],...
            'sample_int', [],...
            'filters', [],...
            'gain', [],...
            'blockAnalysis', []);
        %add the sub-structure for the filters
        filters = struct('blck_fltrs', []);
        
        %blockAnalysis is a sub-structure generated by the fitting process,
        %so it doesn't need to be fully defined at this stage.
        
        %put it all together and return
        dataStruct.filters = filters;
    case {3.4}
        %create an empty data structure for storage in file container
        %version (fcv) 3.4
        dataStruct = struct('filename', [],...
            'linkedFile', [],...
            'pathname', [],...
            'groupname', [],...
            'genotype', [],...
            'concentration', [],...
            'rawdata', [],...
            'rawdataCorr', [],...
            'nrOfBlocks', [],...
            'sample_int', [],...
            'filters', [],...
            'gain', [],...
            'blockAnalysis', []);
        %add the sub-structure for the filters
        filters = struct('blck_fltrs', []);
        
        %blockAnalysis is a sub-structure generated by the fitting process,
        %so it doesn't need to be fully defined at this stage.
        
        %put it all together and return
        dataStruct.filters = filters;
    otherwise
        %unsupported file container version, return an empty structure
        dataStruct = [];
end


end