function cost = cost_DnRstate_model(time,par,EPSC,t_sucroseStart,tau_sucrose_decay, weights, fixedPars)

if min(par)<0 || imag(sum(par)) ~= 0 || max(par) > 1e9
    cost = 10^50; 
    return;
end

if nargin == 4
   tau_sucrose_decay = 0.15;
    weights = cell(1,numel(EPSC));
    for j = 1:numel(EPSC)
        weights(j) = {ones(size(EPSC{j}, 1))};
    end
elseif nargin == 5
    weights = cell(1,numel(EPSC));
    for j = 1:numel(EPSC)
        weights(j) = {ones(size(EPSC{j}, 1))};
    end
end

IC_states = [par(2) par(1)*par(2)/fixedPars(1)];

sucrose_decay = tau_sucrose_decay;

cnt = (numel(EPSC)*3:numel(EPSC)*3+2)-1;
cost = 0;

for i = 1:numel(EPSC)

    param = fixedPars(cnt-3*(i-1));
    k2_conc = sucrose_sigmoid(time{i}, t_sucroseStart, time{i}(end), 0, param(1), param(2), param(3), sucrose_decay);
    [~, release_conc] = simulate_sucrose(time{i},IC_states,par(1),k2_conc,fixedPars);
    
    cost = cost + sum( weights{i}.*(release_conc - EPSC{i}).^2 );
end

end