function cost = cost_Rstate_model(time,par,EPSC,t_sucroseStart,tau_sucrose_decay, weights, fixedPars)

if min(par)<0 || imag(sum(par)) ~= 0 || max(par) > 1e9
    cost = 10^50; 
    return;
end

if nargin == 4
   tau_sucrose_decay = 0.15;
    weights = cell(1,numel(EPSC));
    for j = 1:numel(EPSC)
        weights(j) = {ones(size(EPSC{j}, 1))};
    end
elseif nargin == 5
    weights = cell(1,numel(EPSC));
    for j = 1:numel(EPSC)
        weights(j) = {ones(size(EPSC{j}, 1))};
    end
end

if isempty(fixedPars)
    IC_states = par(1)*1e3./par(2); %D = 1e3
else
    IC_states = fixedPars(end); %fixedPars = [k1 k-1 D R]
end

sucrose_decay = tau_sucrose_decay;

cnt = numel(EPSC)*3:numel(EPSC)*3+2;
cost = 0;

for i = 1:numel(EPSC)
    if isempty(fixedPars)
        param = par(cnt-3*(i-1));
        k2_conc = sucrose_sigmoid(time{i}, t_sucroseStart, time{i}(end), 0, param(1), param(2), param(3), sucrose_decay);
        [~, release_conc] = simulate_sucrose(time{i},IC_states,par([1:2 (cnt-3*(i-1))]),k2_conc);
    else
        k2_conc = sucrose_sigmoid(time{i}, t_sucroseStart, time{i}(end), 0, par(1), par(2), par(3), sucrose_decay);
        [~, release_conc] = simulate_sucrose_fixedPars(time{i},IC_states,fixedPars,k2_conc);
    end

    cost = cost + sum( weights{i}.*(release_conc - EPSC{i}).^2 );

end

%{
if size(EPSC,2) == 2 %Concentration is less than 500mM
    k2_conc = sucrose_sigmoid(time{1}, t_sucroseStart, time{1}(end), 0, par(6), par(7), par(8), sucrose_decay);
    k2_500 = sucrose_sigmoid(time{2}, t_sucroseStart, time{2}(end), 0, par(3), par(4), par(5), sucrose_decay);
    
    [~, release_conc] = simulate_sucrose(time{1},IC_states,par([1:2 6:8]),k2_conc);
    [~, release500] = simulate_sucrose(time{2},IC_states,par(1:5),k2_500);
    
    cost = sum((release_conc-EPSC{1}).^2) + sum((release500-EPSC{2}).^2);
else
    k2_conc = sucrose_sigmoid(time{1}, t_sucroseStart, time{1}(end), 0, par(3), par(4), par(5), sucrose_decay);
    [~, release_conc] = simulate_sucrose(time{1},IC_states,par(1:5),k2_conc);
    
    cost = sum((release_conc-EPSC{1}).^2);
end
%}

end