function [cost] = cost_ves_state_model(time,par,EPSC,t_sucroseStart,tau_sucrose_decay, weights, fixed_par)
%COST_VES_STATE_MODEL Calculate the cost associated with the model
%   

if min(par)<0 || imag(sum(par)) ~= 0 || max(par) > 1e9
    cost = 10^50; 
    return;
end

switch(nargin)
    case 4
        tau_sucrose_decay = 0.15;
        %create the weights
        weights = cell(1,numel(EPSC));
        for j = 1:numel(EPSC)
            weights(j) = {ones(size(EPSC{j}, 1))};
        end
        
        %create fixed par
        fixed_par = nan(1, numel(par));
        fixed_par(end) = 1e3;
    case 5
        %create the weights
        weights = cell(1,numel(EPSC));
        for j = 1:numel(EPSC)
            weights(j) = {ones(size(EPSC{j}, 1))};
        end
        
        %create fixed par
        fixed_par = nan(1, numel(par));
        fixed_par(end) = 1e3;
    case 6
        %create fixed par
        fixed_par = nan(1, numel(par));
    case 7
        if numel(fixed_par) ~= numel(par)
            cost = 10^50;
            return;
        end
    otherwise
        cost = 10^50;
        return;
end

%apply fixed parameters
fltr      = ~isnan(fixed_par);
par(fltr) = fixed_par(fltr);

if fltr(end)
    %D is fixed
    IC_states = par(1)*par(end)/par(2);
else
    %D will be fitted
    IC_states = [par(end) par(1)*par(end)/par(2)];
end

cnt = numel(EPSC)*3:numel(EPSC)*3+2;
cost = 0;

for i = 1:numel(EPSC)
    param = par(cnt-3*(i-1));
    k2_conc = sucrose_sigmoid(time{i}, t_sucroseStart, time{i}(end), 0, param(1), param(2), param(3), tau_sucrose_decay);
    [~, release_conc] = simulate_sucrose(time{i},IC_states,par([1:2 (cnt-3*(i-1)) end]),k2_conc);
    
    cost = cost + sum( weights{i}.*(release_conc - EPSC{i}).^2 );
    %disp(['[' num2str(i) ']: ' num2str(par)]);
end

end

