function [cmap, library] = ArthursCmap(n,getLibrary)
%costum colormap
%Arthur de Jong,
%VU University, Amsterdam 2011

%argin check
error(nargchk(0,2,nargin));

if nargin == 0 
    n = 8;
    getLibrary = false;
elseif nargin == 1
    getLibrary = false;
end

if isempty(n)
    n = 8;
end


if n > 8
    error('ArthursCmap contains just 8 colors');
end

%default library:
library = [];

%define default map:
defaultmap = [0.2  0.2  0.2;
              0    0.6  1;
              1    0    0.1;
              0.1  0.5  0;
              1    0.5  0;
              0.1  0.8  1;
              0.9  0.8  0.1
              0.2  0.5  0.5];   
          
cmap = defaultmap(1:n,:);


%check appdata if colormap already exists:
MyCmap = getappdata(0,'ArthursColormap');

if ~isempty(MyCmap) && ~getLibrary
    %make cmap the right length, and return
    cmap = MyCmap(1:n,:);
    
    return
end



%define library location
script      = mfilename;
scriptpath  = mfilename('fullpath');
scriptpath  = regexprep(scriptpath,script,'');
librarypath = fullfile(scriptpath,'cmapLibrary.mat');

%try to find the library
if exist(librarypath,'file') ~= 2
    %libary not found, use default map and return   
    return
else
    
    try 
        %load the map
        in = load(librarypath);
        
        %get the colormap
        idx    = in.currentmap;
        MyCmap = in.cmap(idx).map;
        
        %place map in appdata:
        setappdata(0,'ArthursColormap',MyCmap)
        
        %store library: 
        library = in;
        library.path = librarypath;
        
    catch me
        %print error in command window
        disp(getReport(me,'extended'));
        
        return
    end
    
end

%make colormap of the correct length:

cmap = MyCmap(1:n,:);
