function [mergedStruct] = mergeSettingsStructures(oldStruct, newStruct, bPreserveValues)
    % MERGESETTINGSSTRUCTURES merge different versions of settings
    % structures
    
    if nargin == 2
        bPreserveValues = true;
    end
    
    if ~isstruct(oldStruct) || ~isstruct(newStruct)
        mergedStruct = [];
        return;
    end
    
    if numel(oldStruct) > 1 || numel(newStruct) > 1
        mergedStruct = [];
        return;
    end
    
    %collect all the fieldnames
    old_fields = fieldnames(oldStruct);
    new_fields = fieldnames(newStruct);
    %put all fields together and find the unique names
    all_fields = unique([old_fields; new_fields]);
    
    for fld = 1:numel(all_fields)
        %determine to which struct this field belongs
        curr_fld = all_fields{fld};
        infield = [isfield(oldStruct, curr_fld) isfield(newStruct, curr_fld)];
        if all(infield)
            %both structures contain the data
            if bPreserveValues
                %take the value from the old structure
                fielddata = oldStruct.(curr_fld);
            else
                %take the value from the new structure
                fielddata = newStruct.(curr_fld);
            end
        else
            %only one structure contains this data, no preservation
            %required for this field
            if infield(1)
               %take the data from the old structure
               fielddata = oldStruct.(curr_fld);
            else
                %take the value from the new structure
                fielddata = newStruct.(curr_fld);
            end
        end
        
        %determine if this is a struct within a struct
        if isstruct(fielddata) && all(infield)
            %this field is a structure as well, recursive
            newdata = newStruct.(curr_fld);
            mergedStruct.(curr_fld) = mergeSettingsStructures(fielddata, newdata, bPreserveValues);
        else
            %raw data, start the merge
            mergedStruct.(curr_fld) = fielddata;
        end
    end
end