function varargout = fitDiscovery_GUI(varargin)
% FITDISCOVERY_GUI MATLAB code for fitDiscovery_GUI.fig
%      FITDISCOVERY_GUI, by itself, creates a new FITDISCOVERY_GUI or raises the existing
%      singleton*.
%
%      H = FITDISCOVERY_GUI returns the handle to a new FITDISCOVERY_GUI or the handle to
%      the existing singleton*.
%
%      FITDISCOVERY_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FITDISCOVERY_GUI.M with the given input arguments.
%
%      FITDISCOVERY_GUI('Property','Value',...) creates a new FITDISCOVERY_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before fitDiscovery_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to fitDiscovery_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help fitDiscovery_GUI

% Last Modified by GUIDE v2.5 27-Jan-2014 09:20:02

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @fitDiscovery_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @fitDiscovery_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before fitDiscovery_GUI is made visible.
function fitDiscovery_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to fitDiscovery_GUI (see VARARGIN)

% Choose default command line output for fitDiscovery_GUI
handles.output = hObject;

%check if the main interface is available
hMain = getappdata(0, 'h_sucrose');

if isempty(hMain)
    %end of the line
    return;
end

%get the index for the file opened for exploring
discIndices = varargin{1}; 
exploreIdx = discIndices(1);
linkIdx    = discIndices(2);

%without a linked file, disable the check box
if linkIdx == 0
    set(handles.check_show_linked, 'Enable', 'off');
end

%get the info from the main appdata
dataStruct   = getappdata(hMain, 'dataStruct');
settings     = getappdata(hMain, 'settings');
exploreRange = settings.explore_range*100;
%set the value in the range box
set(handles.edit_explore_range, 'String', num2str(exploreRange));

if isempty(dataStruct)
    return;
end

%check if analysis has been done
if ~isfield(dataStruct, 'blockAnalysis')
    %analysis has not been done, exit...
    hh = helpdlg('First perform the fit for all the data.', 'Error: missing data');
    uiwait(hh);
    return;
end

%store a handle on the 0 workspace
setappdata(0, 'h_fitDiscovery', gcf);
setappdata(gcf, 'handles', handles);

%start preparing the interface
resetParams = dataStruct(exploreIdx).blockAnalysis(1).parameters;
setappdata(gcf, 'resetParam', resetParams);
setappdata(gcf, 'newDataStruct', dataStruct);
setappdata(gcf, 'exploreIdx', exploreIdx);  %index of the file that holds the data for exploration
setappdata(gcf, 'linkIdx', linkIdx);
setappdata(gcf, 'currentConcentration', dataStruct(exploreIdx).concentration);
%by default set block ID to 1 at startup
setappdata(gcf, 'currBlockID', 1);

%get the original cost for block 1 (default at startup)
originalCost = dataStruct(exploreIdx).blockAnalysis(1).cost;
setappdata(gcf, 'originalCost', originalCost);

%add the current parameters to the correct fields
setCurrentParams(resetParams);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes fitDiscovery_GUI wait for user response (see UIRESUME)
% uiwait(handles.fitDiscovery);


% --- Outputs from this function are returned to the command line.
function varargout = fitDiscovery_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in push_saveExit.
function push_saveExit_Callback(hObject, eventdata, handles)
%get the current parameter settings
par = getCurrentParams();
hDisc = getappdata(0, 'h_fitDiscovery');
%store the new parameters in the selected file(s)
dataStruct = getappdata(hDisc, 'newDataStruct');
exploreIdx = getappdata(hDisc, 'exploreIdx');  %index of the file that holds the data for exploration
linkIdx = getappdata(gcf, 'linkIdx');
blockID = getappdata(hDisc, 'currBlockID');

dataStruct(exploreIdx).blockAnalysis(blockID).parameters = par;
appendSucroseLog(['Parameters for file ' dataStruct(exploreIdx).filename ' were changed.']);

if linkIdx > 0;
    dataStruct(linkIdx).blockAnalysis(blockID).parameters = par;
    appendSucroseLog(['Parameters for file ' dataStruct(linkIdx).filename ' were changed.']);
end

%move the modified datastruct back to the main window
hMain = getappdata(0, 'h_sucrose');
if ~isempty(hMain)
    setappdata(hMain, 'dataStruct', dataStruct);
end

%call the close request function
fitDiscovery_CloseRequestFcn(hDisc, eventdata, handles);

% --- Executes on button press in push_discardExit.
function push_discardExit_Callback(hObject, eventdata, handles)
%call the close request function
hDisc = getappdata(0, 'h_fitDiscovery');
fitDiscovery_CloseRequestFcn(hDisc, eventdata, handles);



function edit_k1_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(1);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_k1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_k1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_k2_500mm_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(3);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_k2_500mm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_k2_500mm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_tau_250mm_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(8);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_tau_250mm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_tau_250mm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_onset_250mm_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(7);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_onset_250mm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_onset_250mm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_kMinus1_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(2);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_kMinus1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_kMinus1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_k2_250mm_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(6);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_k2_250mm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_k2_250mm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_onset_500mm_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(4);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_onset_500mm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_onset_500mm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_poolsize_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(10);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end

% --- Executes during object creation, after setting all properties.
function edit_poolsize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_poolsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in push_fit.
function push_fit_Callback(hObject, eventdata, handles)
makeFitPlots(handles);



function makeFitPlots(handles)
hDisc   = getappdata(0, 'h_fitDiscovery');
blockID = getappdata(hDisc, 'currBlockID');

%get the status of the linked file
if get(handles.check_show_linked, 'Value') == 1
    %display the linked file as well
    bLinked = true;
else
    bLinked = false;
end

dataS = getappdata(hDisc, 'newDataStruct');
idx   = getappdata(hDisc, 'exploreIdx');
data  = dataS(idx);
si    = data.sample_int;

%get the settings from the main interface
hMain    = getappdata(0, 'h_sucrose');
settings = getappdata(hMain, 'settings');

%create the data sets for plotting
rawE  = data.rawdata;
rawT  = (0:numel(rawE)-1)*si;
basel = data.blockAnalysis(blockID).baselineconc(blockID);
epsc  = rawE(data.filters.blck_fltrs(:,blockID))-basel;
time  = rawT(data.filters.blck_fltrs(:,blockID));

%get the linked data if necessary
if bLinked
    linkIdx  = getappdata(hDisc, 'linkIdx');
    linkRawE = dataS(linkIdx).rawdata;
    linkRawT = (0:numel(linkRawE)-1)*si;
    linkBase = dataS(linkIdx).blockAnalysis(blockID).baselineconc(blockID);
    linkEpsc = linkRawE(dataS(linkIdx).filters.blck_fltrs(:,blockID)) - linkBase;
    linkTime = linkRawT(dataS(linkIdx).filters.blck_fltrs(:,blockID));
end

%get the current parameters from the data file
params = getCurrentParams();

%get the original parameters
origPar = getappdata(hDisc, 'resetParam');

%get the handles to the plots
hFit = handles.axes_fit;
hCst = handles.axes_cost;

%calculate the model based on the concentration
currConc = getappdata(hDisc, 'currentConcentration');

%clear the axes fro the new plots
cla(hFit);
cla(hCst);

hold(hFit, 'on');
plot(hFit, time, epsc, 'Color', [0 0 0]);
lgnd = {num2str(currConc)};

if bLinked
    plot(hFit, linkTime, linkEpsc, 'Color', [0.6 0.6 0.6]);
    lgnd(end+1) = {'Linked data'};
end

%determine the start of this block
fitStartBlck = find(data.filters.blck_fltrs(:,blockID), 1, 'first');
fitStartBlck = (fitStartBlck-1)*si;
sucrConcentrations = sort(unique([dataS.concentration]), 'descend');
currSucrIndex      = find(currConc==sucrConcentrations, 1, 'first');
startParIdx = 3 + (currSucrIndex-1)*3;

if  currConc < sucrConcentrations(1)
    k2_subMax     = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(startParIdx), params(startParIdx+1), params(startParIdx+2), settings.sucrose_decay);
    origK2_subMax = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, origPar(startParIdx), origPar(startParIdx+1), origPar(startParIdx+2), settings.sucrose_decay);
    [timeM, release_conc] = simulate_sucrose(time, params(end-1:end), params([1:2 startParIdx:startParIdx+2]), k2_subMax);
    [origTimeM, origRelease_conc] = simulate_sucrose(time, origPar(end-1:end), origPar([1:2 startParIdx:startParIdx+2]), origK2_subMax);
    if bLinked
        k2_max  = sucrose_sigmoid(linkTime, fitStartBlck, linkTime(end), settings.k20, params(3), params(4), params(5), settings.sucrose_decay);
        origK2_max  = sucrose_sigmoid(linkTime, fitStartBlck, linkTime(end), settings.k20, origPar(3), origPar(4), origPar(5), settings.sucrose_decay);
        [linkTimeM, linkRelease_conc] = simulate_sucrose(linkTime, params(end-1:end), params(1:5), k2_max);
        [linkOrigTimeM, linkOrigRelease_conc] = simulate_sucrose(linkTime, origPar(end-1:end), origPar(1:5), origK2_max);
    end
else
    k2_max  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(3), params(4), params(5), settings.sucrose_decay);
    origK2_max  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, origPar(3), origPar(4), origPar(5), settings.sucrose_decay);
    [timeM, release_conc] = simulate_sucrose(time, params(end-1:end), params(1:5), k2_max);
    [origTimeM, origRelease_conc] = simulate_sucrose(time, origPar(end-1:end), origPar(1:5), origK2_max);
    if bLinked
        k2_subMax     = sucrose_sigmoid(linkTime, fitStartBlck, linkTime(end), settings.k20, params(startParIdx), params(startParIdx+1), params(startParIdx+2), settings.sucrose_decay);
        origK2_subMax = sucrose_sigmoid(linkTime, fitStartBlck, linkTime(end), settings.k20, origPar(startParIdx), origPar(startParIdx+1), origPar(startParIdx+2), settings.sucrose_decay);
        [linkTimeM, linkRelease_conc] = simulate_sucrose(linkTime, params(end-1:end), params([1:2 startParIdx:startParIdx+2]), k2_subMax);
        [linkOrigTimeM, linkOrigRelease_conc] = simulate_sucrose(linkTime, origPar(end-1:end), origPar([1:2 startParIdx:startParIdx+2]), origK2_subMax);
    end
end

%plot the fitted data
plot(hFit, origTimeM, origRelease_conc, 'g');   %original data
lgnd(end+1) = {'Original fit'};
plot(hFit, timeM, release_conc, 'm');   %adjusted data
lgnd(end+1) = {'New fit'};

%
if bLinked
    plot(hFit, linkOrigTimeM, linkOrigRelease_conc, 'Color', [0 0.6 0]);   %original data
    lgnd(end+1) = {'Link original fit'};
    plot(hFit, linkTimeM, linkRelease_conc, 'Color', [0.6 0 0.6]);   %adjusted data
    lgnd(end+1) = {'Link new fit'};
end
%}
hold(hFit, 'off');

%add decorations
ylim(hFit, 'auto');
title(hFit, ['Block #' num2str(blockID)]);
xlabel(hFit, 'Time (sec)');
ylabel(hFit, 'Current (pA)');
legend(hFit, lgnd);

%calculate the cost and plot it relative to the original values
if bLinked
    if currConc < sucrConcentrations(1)
        %sub-maximal response
        epscData = {epsc, linkEpsc};
        time     = {time, linkTime};
    else
        epscData = {linkEpsc, epsc};
        time     = {linkTime, time};
    end
else
    epscData = {epsc};
    time     = {time};
end

cost     = cost_Rstate_model(time, params, epscData, fitStartBlck);
costOrig = cost_Rstate_model(time, origPar, epscData, fitStartBlck);

%normalize to the original cost
cost = cost/costOrig;
costOrig = costOrig/costOrig;
%plot the cost
hBar  = barh(hCst, [costOrig cost]);
%get the bar handles and start setting the colors
hBarC = get(hBar, 'Children');
set(hBarC, 'CData', 1:2);
colormap(hCst, [0 1 0; 1 0 1]); %original: green, new: magenta
%remove the tick labels
set(hCst, 'YTick', []);
set(hCst, 'YTickLabel', []);



% --- Executes on button press in push_reset.
function push_reset_Callback(hObject, eventdata, handles)
%get the original parameters and place them in the correct parameters
%fields than replot
hDisc = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

%set the default parameters
setCurrentParams(params);

%create the plots
makeFitPlots(handles);


% --- Executes when user attempts to close fitDiscovery.
function fitDiscovery_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to fitDiscovery (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

prepareForExit();

% Hint: delete(hObject) closes the figure
delete(hObject);



function prepareForExit()
%finished, remove the appdata
rmappdata(0, 'h_fitDiscovery');



function edit_tau_500mm_Callback(hObject, eventdata, handles)
hDisc  = getappdata(0, 'h_fitDiscovery');
params = getappdata(hDisc, 'resetParam');

currVal = str2double(get(hObject,'String'));
defVal  = params(5);

if isnan(currVal) || currVal < 0
    set(hObject,'String', num2str(defVal));
end


% --- Executes during object creation, after setting all properties.
function edit_tau_500mm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_tau_500mm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function [sel] = getRadioSelection(handles)

radiobuttons(1) = get(handles.radio1, 'Value');
radiobuttons(2) = get(handles.radio2, 'Value');
radiobuttons(3) = get(handles.radio3, 'Value');
radiobuttons(4) = get(handles.radio4, 'Value');
radiobuttons(5) = get(handles.radio5, 'Value');
radiobuttons(6) = get(handles.radio6, 'Value');
radiobuttons(7) = get(handles.radio7, 'Value');
radiobuttons(8) = get(handles.radio8, 'Value');
radiobuttons(9) = get(handles.radio9, 'Value');

sel = find(radiobuttons);


function [params] = getCurrentParams()
hDisc      = getappdata(0, 'h_fitDiscovery');
handles    = getappdata(hDisc, 'handles');
currParams = getappdata(hDisc, 'resetParam');
dataS      = getappdata(hDisc, 'newDataStruct');
currConc   = dataS(getappdata(hDisc, 'exploreIdx')).concentration;

%add the reset parameters to the output variable
params             = currParams;
sucrConcentrations = sort(unique([dataS.concentration]), 'descend');
currSucrIndex      = find(currConc==sucrConcentrations, 1, 'first');
strtIdx            = 3 + (currSucrIndex-1)*3;

%collect the parameters and put them in the correct place
params(1)  = str2double(get(handles.edit_k1, 'String'));
params(2)  = str2double(get(handles.edit_kMinus1, 'String'));
%these are the max response values
params(3)  = str2double(get(handles.edit_k2_500mm, 'String'));
params(4)  = str2double(get(handles.edit_onset_500mm, 'String'));
params(5)  = str2double(get(handles.edit_tau_500mm, 'String'));
%these are the sub-max response values for the linked file
params(strtIdx)  = str2double(get(handles.edit_k2_250mm, 'String'));
params(strtIdx+1)  = str2double(get(handles.edit_onset_250mm, 'String'));
params(strtIdx+2)  = str2double(get(handles.edit_tau_250mm, 'String'));
%last two parameters are at fixed positions
params(end-1) = currParams(9);
params(end)   = str2double(get(handles.edit_poolsize, 'String'));

%check for shenannigans
if any(isnan(params))
    %what a naughty user...
    params(isnan(params)) = currParams(isnan(params));
    setCurrentParams(params);
end


function setCurrentParams(params)
hDisc      = getappdata(0, 'h_fitDiscovery');
handles    = getappdata(hDisc, 'handles');
currConc   = getappdata(hDisc, 'currentConcentration');
dataS      = getappdata(hDisc, 'newDataStruct');

%determine the position of the params to change
sucrConcentrations = sort(unique([dataS.concentration]), 'descend');
currSucrIndex      = find(currConc==sucrConcentrations, 1, 'first');
strtIdx            = 3 + (currSucrIndex-1)*3;

%update the max response values
set(handles.edit_k1, 'String', num2str(params(1)));
set(handles.edit_kMinus1, 'String', num2str(params(2)));
set(handles.edit_k2_500mm, 'String', num2str(params(3)));
set(handles.edit_onset_500mm, 'String', num2str(params(4)));
set(handles.edit_tau_500mm, 'String', num2str(params(5)));
%update the sub-max response values
set(handles.edit_k2_250mm, 'String', num2str(params(strtIdx)));
set(handles.edit_onset_250mm, 'String', num2str(params(strtIdx+1)));
set(handles.edit_tau_250mm, 'String', num2str(params(strtIdx+2)));
%set the pool size
set(handles.edit_poolsize, 'String', num2str(params(end)));

%disable certain fields depending on concentration
if currConc < 500
    %disable text fields
    set(handles.edit_k2_500mm, 'Enable', 'off');
    set(handles.edit_onset_500mm, 'Enable', 'off');
    set(handles.edit_tau_500mm, 'Enable', 'off');
    %disable radiobuttons
    set(handles.radio4, 'Enable', 'off');
    set(handles.radio6, 'Enable', 'off');
    set(handles.radio8, 'Enable', 'off');
else
    %disable text fields
    set(handles.edit_k2_250mm, 'Enable', 'off');
    set(handles.edit_onset_250mm, 'Enable', 'off');
    set(handles.edit_tau_250mm, 'Enable', 'off');
    %disable radiobuttons
    set(handles.radio3, 'Enable', 'off');
    set(handles.radio5, 'Enable', 'off');
    set(handles.radio7, 'Enable', 'off');
end


% --- Executes when selected object is changed in panel_explore.
function panel_explore_SelectionChangeFcn(hObject, eventdata, handles)
updateExplorePlot();

function updateExplorePlot()
hDisc   = getappdata(0, 'h_fitDiscovery');
handles = getappdata(hDisc, 'handles');
blockID = getappdata(hDisc, 'currBlockID');

%discover the effect of altering the parameters
sel = getRadioSelection(handles);

hDisc   = getappdata(0, 'h_fitDiscovery');
dataS   = getappdata(hDisc, 'newDataStruct');
idx     = getappdata(hDisc, 'exploreIdx');
linkIdx = getappdata(hDisc, 'linkIdx');
data    = dataS(idx);

%get the current parameters from the edit boxes
params = getCurrentParams();

%get the main interface and its settings
hMain    = getappdata(0, 'h_sucrose');
settings = getappdata(hMain, 'settings');

axFit = handles.axes_fit;
axCst = handles.axes_cost;

%clear the axes before plotting the new data
cla(axFit);
cla(axCst);

%percentage under and over
exploreFactor = settings.explore_range;    %use 10% as exploring factor
exploreUnder  = 1 - exploreFactor;
exploreOver   = 1 + exploreFactor;

%create a set of parameters for Under and Over
paramsU = params;
paramsO = params;

%create a time axis
si    = data.sample_int;
rawE  = data.rawdata;
rawT  = (0:numel(rawE)-1)*si;
fltr  = data.filters.blck_fltrs(:,blockID);
bline = data.blockAnalysis(blockID).baselineconc(blockID);
EPSC  = rawE(fltr) - bline;   %show only data from first block for the time being...
time  = rawT(fltr);

if linkIdx > 0
    linkEPSC  = dataS(linkIdx).rawdata;
    linkTIME  = (0:numel(linkEPSC)-1)*si;
    linkBLINE = dataS(linkIdx).blockAnalysis(blockID).baselineconc(blockID);
    linkFLTR  = dataS(linkIdx).filters.blck_fltrs(:,blockID);
    
    linkEPSC = linkEPSC(linkFLTR) - linkBLINE;
    linkTIME = linkTIME(linkFLTR);
end

%determine the start of this block
fitStartBlck = find(data.filters.blck_fltrs(:,blockID), 1, 'first');
fitStartBlck = (fitStartBlck-1)*si;
sucrConcentrations = sort(unique([dataS.concentration]), 'descend');
currSucrIndex      = find(data.concentration==sucrConcentrations, 1, 'first');
startParIdx = 3 + (currSucrIndex-1)*3;

if data.concentration < sucrConcentrations(1)
    bLessThanMax = true;
    k2_conc = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(startParIdx), params(startParIdx+1), params(startParIdx+2), settings.sucrose_decay);
else
    bLessThanMax = false;
    k2_conc = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(3), params(4), params(5), settings.sucrose_decay);
end

k2_concU = k2_conc;
k2_concO = k2_conc;

%color for the plot is black by default
colspec = [0 0 0];

switch(sel)
    case 1
        %explore the k1 value
        i = 1;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        %recalculate R parameter
%         paramsU(end) = (paramsU(end-1)*paramsU(1))/paramsU(2);
%         paramsO(end) = (paramsO(end-1)*paramsO(1))/paramsO(2);
        if data.concentration == sucrConcentrations(1)
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
            bLessThanMax = true;
        else
            costTime = {time linkTIME};
            costEPSC = {EPSC linkEPSC};
        end
    case 2
        %explore the k-1 value
        i = 2;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        %recalculate R parameter
%         paramsU(end) = (paramsU(end-1)*paramsU(1))/paramsU(2);
%         paramsO(end) = (paramsO(end-1)*paramsO(1))/paramsO(2);
        if data.concentration == sucrConcentrations(1)
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
            %time = linkTIME;
            %EPSC = linkEPSC;
            bLessThanMax = true;
        else
            costTime = {time linkTIME};
            costEPSC = {EPSC linkEPSC};
        end
    case 3
        %explore the k2 250mM value
        i = startParIdx;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        %load the linked data if this is not the less than 500mM data
        if data.concentration == sucrConcentrations(1)
            colspec = [0.6 0.6 0.6];
            costEPSC = {linkEPSC EPSC};
            costTime = {linkTIME time};
            time = linkTIME;
            EPSC = linkEPSC;
            bLessThanMax = true;
        else
            costEPSC = {EPSC linkEPSC};
            costTime = {time linkTIME};
        end
        k2_concU = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsU(startParIdx), paramsU(startParIdx+1), paramsU(startParIdx+2), settings.sucrose_decay);
        k2_conc  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(startParIdx), params(startParIdx+1), params(startParIdx+2), settings.sucrose_decay);
        k2_concO = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsO(startParIdx), paramsO(startParIdx+1), paramsO(startParIdx+2), settings.sucrose_decay);
    case 4
        %explore the k2 500mM value
        i = 3;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        %define the data for the linked file if this file is less than
        %500mM
        if data.concentration < sucrConcentrations(1)
            colspec = [0.6 0.6 0.6];
            costTime = {time linkTIME};
            costEPSC = {EPSC linkEPSC};
            time = linkTIME;
            EPSC = linkEPSC;
            bLessThanMax = false;
        else
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
        end
        k2_concU = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsU(3), paramsU(4), paramsU(5), settings.sucrose_decay);
        k2_conc  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(3), params(4), params(5), settings.sucrose_decay);
        k2_concO = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsO(3), paramsO(4), paramsO(5), settings.sucrose_decay);
        
    case 5
        %explore the onset 250mM value
        i = startParIdx+1;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        if data.concentration == sucrConcentrations(1)
            colspec = [0.6 0.6 0.6];
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
            time = linkTIME;
            EPSC = linkEPSC;
            bLessThanMax = true;
        else
            costEPSC = {EPSC linkEPSC};
            costTime = {time, linkTIME};
        end
         k2_concU = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsU(startParIdx), paramsU(startParIdx+1), paramsU(startParIdx+2), settings.sucrose_decay);
        k2_conc  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(startParIdx), params(startParIdx+1), params(startParIdx+2), settings.sucrose_decay);
        k2_concO = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsO(startParIdx), paramsO(startParIdx+1), paramsO(startParIdx+2), settings.sucrose_decay);
    case 6
        %explore the onset 500mM value
        i = 4;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        if data.concentration < sucrConcentrations(1)
            colspec = [0.6 0.6 0.6];
            costTime = {time linkTIME};
            costEPSC = {EPSC linkEPSC};
            time = linkTIME;
            EPSC = linkEPSC;
            bLessThanMax = false;
        else
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
        end
        k2_concU = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsU(3), paramsU(4), paramsU(5), settings.sucrose_decay);
        k2_conc  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(3), params(4), params(5), settings.sucrose_decay);
        k2_concO = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsO(3), paramsO(4), paramsO(5), settings.sucrose_decay);
        
    case 7
        %explore the tau 250mM value
        i = startParIdx+2;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        if data.concentration == sucrConcentrations(1)
            colspec = [0.6 0.6 0.6];
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
            time = linkTIME;
            EPSC = linkEPSC;
            bLessThanMax = true;
        else
            costEPSC = {EPSC linkEPSC};
            costTime  ={time linkTIME};
        end
         k2_concU = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsU(startParIdx), paramsU(startParIdx+1), paramsU(startParIdx+2), settings.sucrose_decay);
        k2_conc  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(startParIdx), params(startParIdx+1), params(startParIdx+2), settings.sucrose_decay);
        k2_concO = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsO(startParIdx), paramsO(startParIdx+1), paramsO(startParIdx+2), settings.sucrose_decay);
    case 8
        %explore the tau 500mM value
        i = 5;
        paramsU(i) = paramsU(i) * exploreUnder;
        paramsO(i) = paramsO(i) * exploreOver;
        
        %define the data for the linked file
        if data.concentration < sucrConcentrations(1)
            colspec = [0.6 0.6 0.6];
            costTime = {time linkTIME};
            costEPSC = {EPSC linkEPSC};
            time = linkTIME;
            EPSC = linkEPSC;
            bLessThanMax = false;
        else
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
        end
        %calculate the k2 for this concentration
        k2_concU = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsU(3), paramsU(4), paramsU(5), settings.sucrose_decay);
        k2_conc  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, params(3), params(4), params(5), settings.sucrose_decay);
        k2_concO = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, paramsO(3), paramsO(4), paramsO(5), settings.sucrose_decay);
    case 9
        %explore the pool size value (R)
        paramsU(end-1) = paramsU(end-1) * exploreUnder;
        paramsO(end-1) = paramsO(end-1) * exploreOver;
        %recalculate R parameter
%         paramsU(end) = (paramsU(end-1)*paramsU(1))/paramsU(2);
%         paramsO(end) = (paramsO(end-1)*paramsO(1))/paramsO(2);
        if data.concentration == sucrConcentrations(1)
            time = linkTIME;
            costTime = {linkTIME time};
            costEPSC = {linkEPSC EPSC};
            bLessThanMax = true;
        else
            costEPSC = {EPSC linkEPSC};
            costTime = {time linkTIME};
        end
    otherwise
        %oops...
end



%generate the data based on the 3 sets of parameters
if bLessThanMax %data.concentration < 500
    %use the data belonging to the parameter under investigation being less
    %than 500mM
    [timeU, releaseU] = simulate_sucrose(time, paramsU(end-1:end), paramsU([1:2 startParIdx:startParIdx+2]), k2_concU);
    [time, release]   = simulate_sucrose(time, params(end-1:end), params([1:2 startParIdx:startParIdx+2]), k2_conc);
    [timeO, releaseO] = simulate_sucrose(time, paramsO(end-1:end), paramsO([1:2 startParIdx:startParIdx+2]), k2_concO);
    %calculate the cost
    costU = cost_Rstate_model(costTime, paramsU, costEPSC, fitStartBlck); %under
    cost  = cost_Rstate_model(costTime, params, costEPSC, fitStartBlck);  %original
    costO = cost_Rstate_model(costTime, paramsO, costEPSC, fitStartBlck); %over
else
    [timeU, releaseU] = simulate_sucrose(time, paramsU(end-1:end), paramsU(1:5), k2_concU);
    [time, release]   = simulate_sucrose(time, params(end-1:end), params(1:5), k2_conc);
    [timeO, releaseO] = simulate_sucrose(time, paramsO(end-1:end), paramsO(1:5), k2_concO);
    %calculate the cost for each exploratory value
    costU = cost_Rstate_model(costTime, paramsU, costEPSC, fitStartBlck); %under
    cost  = cost_Rstate_model(costTime, params, costEPSC, fitStartBlck);  %original
    costO = cost_Rstate_model(costTime, paramsO, costEPSC, fitStartBlck); %over
end



%plot the results
hold(axFit, 'on');
%raw data first
plot(axFit, time, EPSC, 'Color', colspec);
%then the model fits
plot(axFit, time, release, 'g');
plot(axFit, timeU, releaseU, 'r');
plot(axFit, timeO, releaseO, 'b');
hold(axFit, 'off');
%add decorations to the plot
title(axFit, ['Block #' num2str(blockID)]);
xlabel(axFit,'Time (sec)');
ylabel(axFit,'Current (pA)');
legend(axFit,{'Raw data' 'Original' 'Under' 'Over'});

%plot the cost values: normalize to the original
costU_norm = costU/cost;
cost_norm  = cost/cost;
costO_norm = costO/cost;

%plot a horizontal barplot
h_bar  = barh(axCst, [cost_norm, costU_norm costO_norm]);
%adjust the colors
h_barC = get(h_bar, 'Children');
set(h_barC, 'CData', 1:3);
colormap(axCst, [0 1 0; 1 0 0; 0 0 1]); %green > red > blue
%remove the tick labels
set(axCst, 'YTick', []);
set(axCst, 'YTickLabel', []);



function edit_explore_range_Callback(hObject, eventdata, handles)
% hObject    handle to edit_explore_range (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_explore_range as text
%        str2double(get(hObject,'String')) returns contents of edit_explore_range as a double
exploreRange = str2double(get(hObject,'String'));

if isnan(exploreRange)
    exploreRange = 10;
end

if exploreRange <= 0 || exploreRange >= 100
    exploreRange = 10;
end

%make sure the value is set correctly
set(hObject, 'String', num2str(exploreRange));

%convert from percentage to value
exploreRange = exploreRange/100;

hMain = getappdata(0, 'h_sucrose');
settings = getappdata(hMain, 'settings');
settings.explore_range = exploreRange;
setappdata(hMain, 'settings', settings);

updateExplorePlot();




% --- Executes during object creation, after setting all properties.
function edit_explore_range_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_explore_range (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in check_show_linked.
function check_show_linked_Callback(hObject, eventdata, handles)
% hObject    handle to check_show_linked (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
currState = get(handles.check_show_linked, 'Value');
hDisc = getappdata(0, 'h_fitDiscovery');
currConc = getappdata(hDisc, 'currentConcentration');

switch(currState)
    case 0
        if currConc < 500
            %switched off, disable fields
            set(handles.edit_k2_500mm, 'Enable', 'off');
            set(handles.edit_onset_500mm, 'Enable', 'off');
            set(handles.edit_tau_500mm, 'Enable', 'off');
            %switch off 500mM controls
            set(handles.radio4, 'Enable', 'off');
            set(handles.radio6, 'Enable', 'off');
            set(handles.radio8, 'Enable', 'off');
            %switch on 250mM controls
            set(handles.radio3, 'Enable', 'on');
            set(handles.radio5, 'Enable', 'on');
            set(handles.radio7, 'Enable', 'on');
        else
            set(handles.edit_k2_250mm, 'Enable', 'off');
            set(handles.edit_onset_250mm, 'Enable', 'off');
            set(handles.edit_tau_250mm, 'Enable', 'off');
            %switch on 500mM controls
            set(handles.radio4, 'Enable', 'on');
            set(handles.radio6, 'Enable', 'on');
            set(handles.radio8, 'Enable', 'on');
            %switch off 250mM controls
            set(handles.radio3, 'Enable', 'off');
            set(handles.radio5, 'Enable', 'off');
            set(handles.radio7, 'Enable', 'off');
        end
    case 1
        %show linked data activated show all controls
        set(handles.edit_k2_500mm, 'Enable', 'on');
        set(handles.edit_onset_500mm, 'Enable', 'on');
        set(handles.edit_tau_500mm, 'Enable', 'on');
        set(handles.edit_k2_250mm, 'Enable', 'on');
        set(handles.edit_onset_250mm, 'Enable', 'on');
        set(handles.edit_tau_250mm, 'Enable', 'on');
        %switch on 500mM controls
        set(handles.radio4, 'Enable', 'on');
        set(handles.radio6, 'Enable', 'on');
        set(handles.radio8, 'Enable', 'on');
        %switch on 250mM controls
        set(handles.radio3, 'Enable', 'on');
        set(handles.radio5, 'Enable', 'on');
        set(handles.radio7, 'Enable', 'on');
end

makeFitPlots(handles);


% --------------------------------------------------------------------
function uipush_previous_ClickedCallback(hObject, eventdata, handles)
h = getappdata(0, 'h_fitDiscovery');
currBlock = getappdata(h, 'currBlockID');
newBlock = currBlock - 1;

dataS   = getappdata(h, 'newDataStruct');
idx     = getappdata(h, 'exploreIdx');
data    = dataS(idx);

if newBlock < 1
    newBlock = 1;
end

%set the parameters and cost with the new block info
resetParams = data.blockAnalysis(newBlock).parameters;
origCost    = data.blockAnalysis(newBlock).cost;
setappdata(h, 'resetParam', resetParams);
setappdata(h, 'originalCost', origCost);
setCurrentParams(resetParams);

setappdata(h, 'currBlockID', newBlock)
makeFitPlots(handles);

% --------------------------------------------------------------------
function uipush_next_ClickedCallback(hObject, eventdata, handles)
h = getappdata(0, 'h_fitDiscovery');
currBlock = getappdata(h, 'currBlockID');
newBlock = currBlock + 1;

dataS   = getappdata(h, 'newDataStruct');
idx     = getappdata(h, 'exploreIdx');
data    = dataS(idx);

if newBlock > data.nrOfBlocks
    newBlock = data.nrOfBlocks;
end

%set the parameters and cost with the new block info
resetParams = data.blockAnalysis(newBlock).parameters;
origCost    = data.blockAnalysis(newBlock).cost;
setappdata(h, 'resetParam', resetParams);
setappdata(h, 'originalCost', origCost);
setCurrentParams(resetParams);

setappdata(h, 'currBlockID', newBlock);
makeFitPlots(handles);


