function [par, cost] = fit_DnRsucrose(time_fit, fit_EPSC, par_init, fitType, fixedPars)
hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    fit_options = optimset('Display', 'on');
    settings.reusePrevious = false;
else
    settings    = getappdata(hMain, 'settings');
    if strcmpi(settings.outputDisplay, 'diagnose')
        outDisp = 'final';
    else
        outDisp = settings.outputDisplay;
    end
    fit_options = optimset( 'MaxFunEvals', settings.MaxFunEvals*numel(par_init),...
                            'MaxIter', settings.MaxIter*numel(par_init),...
                            'Display', outDisp);
end

if nargin ~=5
    par  = [];
    cost = [];
    return;
end

t_sucroseStart = 0; %time_fit(1);

if settings.useWeightedFit
    %use a weight function
    weights = cell(1,numel(fit_EPSC));
    for i = 1:numel(fit_EPSC)-1
        peakRatio = floor(min(fit_EPSC{end})/min(fit_EPSC{i}));
        if peakRatio <= 0
           peakRatio = 1;
        end
        weights(i) = {sucroseWeightedFit(fit_EPSC{i}, 0.1, peakRatio)};
    end
    weights(end) = {ones( size(fit_EPSC{end}, 1), 1)};
else
    weights = cell(1,numel(fit_EPSC));
    for i = 1:numel(fit_EPSC)
        weights(i) = {ones(size(fit_EPSC{i}, 1), 1)};
    end
end

%Fit response with fixed values
cost_fn = @(fit_par)cost_DnRstate_model(time_fit,fit_par,fit_EPSC,t_sucroseStart,settings.sucrose_decay, weights, fixedPars);
[par, cost] = performFit(cost_fn, par_init, fitType, settings, fit_options);

R = (par(1)*par(2))/fixedPars(1);
par = [par(1) fixedPars par(2) R];

end

function [par, cost] = performFit(cost_fn, par_init, fitType, settings, fit_options)
hMain = getappdata(0, 'h_sucrose');
%Perform fit
switch(fitType)
    case 'anneal'
        options_anneal = saoptimset('simulannealbnd');
        options_anneal.Display = settings.outputDisplay;
        lb = zeros(1,numel(par_init));
        ub = ones(1,numel(par_init))*1e9;
        [par, cost, ~, output] = simulannealbnd(cost_fn, par_init, lb, ub, options_anneal);
        exitFlag = 0; %Force local search
    case 'genetic'
        options_genetic = gaoptimset;
        options_genetic.Display = settings.outputDisplay;
        options_genetic.Generations = settings.MaxIter*numel(par_init);
        lb = [1e-5 1e-5]; %ones(1,numel(par_init))*1e-5;
        ub = [1e2 1e9]; %ones(1,numel(par_init))*1e9;
        [par, cost, ~] = ga(cost_fn,numel(par_init),[],[],[],[], lb, ub, [], options_genetic);
        exitFlag = 0; %Force local search
    otherwise
        [par, cost, exitFlag, output] = fminsearch(cost_fn, par_init, fit_options); 
end

if exitFlag == 0
    %continue the fit
    [par, cost, ~, output] = fminsearch(cost_fn, par, fit_options);
end


%if parameters should be reused, store them
if settings.reusePrevious
    settings.par_previous = par;
    setappdata(hMain, 'settings', settings);
    appendSucroseLog('New parameters were stored.');
end
    
%log the final message
%appendSucroseLog(output.message, 'info');

end