function [par, cost] = fit_sucrose(time_fit, fit_EPSC, par_init, fitType, fixedPars)
hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    fit_options = optimset('Display', 'on');
    settings.reusePrevious = false;
else
    settings    = getappdata(hMain, 'settings');
    if strcmpi(settings.outputDisplay, 'diagnose')
        outDisp = 'final';
    else
        outDisp = settings.outputDisplay;
    end
    fit_options = optimset( 'MaxFunEvals', settings.MaxFunEvals*numel(par_init),...
                            'MaxIter', settings.MaxIter*numel(par_init),...
                            'Display', outDisp);
end

if nargin == 3
   fitType = 'default';
   fixedPars = nan(1, numel(par_init));
   fixedPars(end) = 1e3;
elseif nargin == 4
    fixedPars = nan(1, numel(par_init));
    fixedPars(end) = 1e3;
elseif nargin > 5
    par  = [];
    cost = [];
    return;
end

t_sucroseStart = 0; %time_fit(1);

if settings.useWeightedFit
    %use a weight function
    weights = cell(1,numel(fit_EPSC));
    for i = 1:numel(fit_EPSC)-1
        peakRatio = floor(min(fit_EPSC{end})/min(fit_EPSC{i}));
        if peakRatio <= 0
           peakRatio = 1;
        end
        weights(i) = {sucroseWeightedFit(fit_EPSC{i}, 0.1, peakRatio)};
    end
    weights(end) = {ones( size(fit_EPSC{end}, 1), 1)};
else
    weights = cell(1,numel(fit_EPSC));
    for i = 1:numel(fit_EPSC)
        weights(i) = {ones(size(fit_EPSC{i}, 1), 1)};
    end
end

%Fit response with fixed values
cost_fn = @(fit_par)cost_ves_state_model(time_fit,fit_par,fit_EPSC,t_sucroseStart,settings.sucrose_decay, weights, fixedPars);
[par, cost] = performFit(cost_fn, par_init, fitType, settings, fit_options, fixedPars);
%{
if settings.useExtended
    %leave k1 and D free
    fixedPars = nan(1, numel(par));
    
    %create a filter to set k1 and D
    fltr = true(1, numel(par));
    fltr([1 end]) = false;
    
    %apply the filter and perform the fit
    fixedPars(fltr) = par(fltr);
    cost_fn = @(fit_par)cost_ves_state_model(time_fit,fit_par,fit_EPSC,t_sucroseStart,settings.sucrose_decay, weights, fixedPars);
    [par, cost] = performFit(cost_fn, par_init, 'genetic', settings, fit_options, fixedPars);
    
    %apply fixed pars to found parameters
    par(fltr) = fixedPars(fltr);
end
%}
R = (par(1)*par(end))/par(2);
par = [par R];

%{   
if settings.useFixedParam
    
    %Fit max response
    cost_fn = @(fit_par)cost_ves_state_model(time_fit(end),fit_par(1:5),fit_EPSC(end),t_sucroseStart,settings.sucrose_decay, weights(end));
    [parMax, costMax] = performFit(cost_fn, par_init(1:5), fitType, settings, fit_options);
    
    D = 1e3;
    k1 = fit_refill_phase(time_fit{end}, fit_EPSC{end}); %Fit single exponential to refill phase of 500mM
    if k1 > 0
        D = (parMax(1)*D)/k1;
        parMax(1) = k1;
        R = (k1*D)/parMax(2);
    else
        R = (parMax(1)*D)/parMax(2);
    end
    
    fixedPars = [parMax(1:2) D R];
    
    %Fit submax response
    cost_fn = @(fit_par)cost_ves_state_model(time_fit(1),fit_par(1:3),fit_EPSC(1),t_sucroseStart,settings.sucrose_decay, weights(1), fixedPars);
    [parSubmax, costSubmax] = performFit(cost_fn, par_init(end-2:end), fitType, settings, fit_options);
    
    par = [parMax parSubmax D R];
    cost = costMax + costSubmax;
   
    
    
    
else
    cost_fn = @(fit_par)cost_ves_state_model(time_fit,fit_par,fit_EPSC,t_sucroseStart,settings.sucrose_decay, weights);
    [par, cost] = performFit(cost_fn, par_init, fitType, settings, fit_options);
    D = par(end);
    R = (par(1)*D)/par(2);
    
    par = [par R];
    
    %{
    if ~settings.useExtended
        cost_fn = @(fit_par)cost_ves_state_model(time_fit,fit_par,fit_EPSC,t_sucroseStart,settings.sucrose_decay, weights, []);
        [par, cost] = performFit(cost_fn, par_init, fitType, settings, fit_options);
        
        D = 1e3;
        k1 = fit_refill_phase(time_fit{end}, fit_EPSC{end}); %Fit single exponential to refill phase of 500mM
        if k1 > 0
            D = (par(1)*D)/k1;
            par(1) = k1;
            R = (k1*D)/par(2);
        else
            R = (par(1)*D)/par(2);
        end        
        par = [par D R];
    else
        cost_fn = @(fit_par)cost_ves_state_model(time_fit,fit_par,fit_EPSC,t_sucroseStart,settings.sucrose_decay, weights, []);
        [par, cost] = performFit(cost_fn, par_init, fitType, settings, fit_options);
        D = par(end);
        R = (par(1)*D)/par(2);
        
        par = [par R];
    end
    %}
end
%}
end

function [par, cost] = performFit(cost_fn, par_init, fitType, settings, fit_options, fixedPars)
hMain = getappdata(0, 'h_sucrose');
fltr = ~isnan(fixedPars);

numConc = ceil((numel(par_init)/3)-1);

%Perform fit
switch(fitType)
    case 'anneal'
        options_anneal = saoptimset('simulannealbnd');
        options_anneal.Display = settings.outputDisplay;
        lb = zeros(1,numel(par_init));
        ub = ones(1,numel(par_init))*1e9;
        [par, cost, ~, output] = simulannealbnd(cost_fn, par_init, lb, ub, options_anneal);
        exitFlag = 0; %Force local search
    case 'genetic'
        options_genetic = gaoptimset();
        options_genetic.Display = settings.outputDisplay;
        options_genetic.Generations = settings.MaxIter*numel(par_init);
        %options_genetic.MutationFcn = @mutationadaptfeasible;
        %population size critically determines the quality of fit,
        %especially for multiple concentrations
        options_genetic.PopulationSize = numConc*10;
        lb = ones(1,numel(par_init))*1e-5;
        ub = ones(1,numel(par_init))*1e9;
        [par, cost, ~] = ga(cost_fn,numel(par_init),[],[],[],[], lb, ub, [], options_genetic);
        exitFlag = 0; %Force local search
    otherwise
        [par, cost, exitFlag, output] = fminsearch(cost_fn, par_init, fit_options); 
end

%apply fixed pars to found parameters
par(fltr) = fixedPars(fltr);

if exitFlag == 0
    %continue the fit
    [par, cost, ~, output] = fminsearch(cost_fn, par, fit_options);
    %apply fixed pars to found parameters
    par(fltr) = fixedPars(fltr);
end


%if parameters should be reused, store them
if settings.reusePrevious
    settings.par_previous = par(1:end-1);
    setappdata(hMain, 'settings', settings);
    appendSucroseLog('New parameters were stored.');
end
    
%log the final message
%appendSucroseLog(output.message, 'info');

end