%SucroseAnalysis expects data from a *.mat file in a modDataStruct structure
%The structure should contain the fields: filename, data, header, si

%create structure with name specified in sucrose analysis
modDataStruct = struct;
%load data
[files, path, ~] = uigetfile({'*.abf',  'Axon files (*.abf)';'*.mat', 'Matlab data files (*.mat)'}, 'Select files',...
    'MultiSelect', 'on');

if path == 0
    %user canceled
    return;
end

if ~iscell(files)
    files = {files};
end

for f = 1:numel(files)
    filename = fullfile(path, files{f});
    
    %get the data from the file
    [data, si, header] = abfload(filename);
    %if data contains more than 1 column: ignore the others
    if size(data, 2) > 1
        data = data(:,1);
    end
    %Perform modification on data here
            %-Placeholder for modifaction function
    %Store data in structure
    if isempty(fieldnames(modDataStruct))
        modDataStruct.filename = files{f};
        modDataStruct.data = data;
        modDataStruct.header = header;
        modDataStruct.si = si;
    else
        modDataStruct(end+1).filename = files{f};
        modDataStruct(end).data = data;
        modDataStruct(end).header = header;
        modDataStruct(end).si = si;
    end
end

%save data structure
save('SucData.mat', 'modDataStruct');

