function [time, release, varargout] = simulate_sucrose(time,IC_states,par,k2,fixedPars)
%{
if numel(IC_states) == 1
    [t,ves_states] = ode45(@(t,states)Rstate_model(t,states,par,time,k2),...
        [time(1) time(end)],IC_states);
elseif numel(IC_states) == 2
    [t,ves_states] = ode45(@(t,states)DnRstate_model(t,states,par,time,k2),...
        [time(1) time(end)],IC_states);
end
%}

switch(nargin)
    case 4
        [t,ves_states] = ode45(@(t,states)ves_state_model(t,states,par,time,k2),...
            [time(1) time(end)],IC_states);
    case 5
        [t,ves_states] = ode45(@(t,states)DnRstate_model(t,states,par,time,k2,fixedPars),...
            [time(1) time(end)],IC_states);
    otherwise
        time = [];
        release = [];
        return;
end
    
ves_states = interp1q(t,ves_states,time');
release = -ves_states(:,end).*k2; %-k2*R

if nargout == 3
    varargout{1} = ves_states;
end

end